/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class FileBackedMimeBodyPart
extends MimeBodyPart {
    private static final int BUF_SIZE = 32760;
    private final File _file;

    public FileBackedMimeBodyPart(File file) throws MessagingException, IOException {
        super((InputStream)new SharedFileInputStream(file));
        this._file = file;
    }

    public FileBackedMimeBodyPart(InputStream inputStream2, File file) throws MessagingException, IOException {
        this(FileBackedMimeBodyPart.saveStreamToFile(inputStream2, file));
    }

    public FileBackedMimeBodyPart(InternetHeaders internetHeaders, InputStream inputStream2, File file) throws MessagingException, IOException {
        this(FileBackedMimeBodyPart.saveStreamToFile(internetHeaders, inputStream2, file));
    }

    public void writeTo(OutputStream outputStream2) throws IOException, MessagingException {
        if (!this._file.exists()) {
            throw new IOException("file " + this._file.getCanonicalPath() + " no longer exists.");
        }
        super.writeTo(outputStream2);
    }

    public void dispose() throws IOException {
        ((SharedFileInputStream)this.contentStream).getRoot().dispose();
        if (this._file.exists() && !this._file.delete()) {
            throw new IOException("deletion of underlying file <" + this._file.getCanonicalPath() + "> failed.");
        }
    }

    private static File saveStreamToFile(InputStream inputStream2, File file) throws IOException {
        FileBackedMimeBodyPart.saveContentToStream(new FileOutputStream(file), inputStream2);
        return file;
    }

    private static File saveStreamToFile(InternetHeaders internetHeaders, InputStream inputStream2, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Enumeration enumeration = internetHeaders.getAllHeaderLines();
        while (enumeration.hasMoreElements()) {
            FileBackedMimeBodyPart.writeHeader(fileOutputStream, (String)enumeration.nextElement());
        }
        FileBackedMimeBodyPart.writeSeperator(fileOutputStream);
        FileBackedMimeBodyPart.saveContentToStream(fileOutputStream, inputStream2);
        return file;
    }

    private static void writeHeader(OutputStream outputStream2, String string) throws IOException {
        for (int i = 0; i != string.length(); ++i) {
            outputStream2.write(string.charAt(i));
        }
        FileBackedMimeBodyPart.writeSeperator(outputStream2);
    }

    private static void writeSeperator(OutputStream outputStream2) throws IOException {
        outputStream2.write(13);
        outputStream2.write(10);
    }

    private static void saveContentToStream(OutputStream outputStream2, InputStream inputStream2) throws IOException {
        int n;
        byte[] byArray = new byte[32760];
        while ((n = inputStream2.read(byArray, 0, byArray.length)) > 0) {
            outputStream2.write(byArray, 0, n);
        }
        outputStream2.close();
        inputStream2.close();
    }
}

