/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import org.bouncycastle.mail.smime.SMIMEUtil;

public class multipart_signed
implements DataContentHandler {
    private static final ActivationDataFlavor ADF = new ActivationDataFlavor(MimeMultipart.class, "multipart/signed", "Multipart Signed");
    private static final DataFlavor[] DFS = new DataFlavor[]{ADF};

    public Object getContent(DataSource dataSource) throws IOException {
        try {
            return new MimeMultipart(dataSource);
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        if (ADF.equals(dataFlavor)) {
            return this.getContent(dataSource);
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return DFS;
    }

    public void writeTo(Object object, String string, OutputStream outputStream2) throws IOException {
        if (object instanceof MimeMultipart) {
            try {
                this.outputBodyPart(outputStream2, object);
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException.getMessage());
            }
        } else if (object instanceof byte[]) {
            outputStream2.write((byte[])object);
        } else if (object instanceof InputStream) {
            int n;
            InputStream inputStream2 = (InputStream)object;
            if (!(inputStream2 instanceof BufferedInputStream)) {
                inputStream2 = new BufferedInputStream(inputStream2);
            }
            while ((n = inputStream2.read()) >= 0) {
                outputStream2.write(n);
            }
            inputStream2.close();
        } else if (object instanceof SMIMEStreamingProcessor) {
            SMIMEStreamingProcessor sMIMEStreamingProcessor = (SMIMEStreamingProcessor)object;
            sMIMEStreamingProcessor.write(outputStream2);
        } else {
            throw new IOException("unknown object in writeTo " + object);
        }
    }

    private void outputBodyPart(OutputStream outputStream2, Object object) throws MessagingException, IOException {
        Object object2;
        if (object instanceof Multipart) {
            Multipart multipart = (Multipart)object;
            ContentType contentType = new ContentType(multipart.getContentType());
            String string = "--" + contentType.getParameter("boundary");
            LineOutputStream lineOutputStream = new LineOutputStream(outputStream2);
            for (int i = 0; i < multipart.getCount(); ++i) {
                lineOutputStream.writeln(string);
                this.outputBodyPart(outputStream2, multipart.getBodyPart(i));
                lineOutputStream.writeln();
            }
            lineOutputStream.writeln(string + "--");
            return;
        }
        MimeBodyPart mimeBodyPart = (MimeBodyPart)object;
        if (SMIMEUtil.isMultipartContent((Part)mimeBodyPart) && (object2 = mimeBodyPart.getContent()) instanceof Multipart) {
            Multipart multipart = (Multipart)object2;
            ContentType contentType = new ContentType(multipart.getContentType());
            String string = "--" + contentType.getParameter("boundary");
            LineOutputStream lineOutputStream = new LineOutputStream(outputStream2);
            Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                lineOutputStream.writeln((String)enumeration.nextElement());
            }
            lineOutputStream.writeln();
            multipart_signed.outputPreamble(lineOutputStream, mimeBodyPart, string);
            this.outputBodyPart(outputStream2, multipart);
            return;
        }
        mimeBodyPart.writeTo(outputStream2);
    }

    static void outputPreamble(LineOutputStream lineOutputStream, MimeBodyPart mimeBodyPart, String string) throws MessagingException, IOException {
        String string2;
        InputStream inputStream2;
        try {
            inputStream2 = mimeBodyPart.getRawInputStream();
        }
        catch (MessagingException messagingException) {
            return;
        }
        while ((string2 = multipart_signed.readLine(inputStream2)) != null && !string2.equals(string)) {
            lineOutputStream.writeln(string2);
        }
        inputStream2.close();
        if (string2 == null) {
            throw new MessagingException("no boundary found");
        }
    }

    private static String readLine(InputStream inputStream2) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream2.read()) >= 0 && n != 10) {
            if (n == 13) continue;
            stringBuffer.append((char)n);
        }
        if (n < 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private static class LineOutputStream
    extends FilterOutputStream {
        private static byte[] newline = new byte[2];

        public LineOutputStream(OutputStream outputStream2) {
            super(outputStream2);
        }

        public void writeln(String string) throws MessagingException {
            try {
                byte[] byArray = LineOutputStream.getBytes(string);
                this.out.write(byArray);
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        public void writeln() throws MessagingException {
            try {
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        private static byte[] getBytes(String string) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)cArray[n2++];
            }
            return byArray;
        }

        static {
            LineOutputStream.newline[0] = 13;
            LineOutputStream.newline[1] = 10;
        }
    }
}

