/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSException;

public class SMIMEEnvelopedParser
extends CMSEnvelopedDataParser {
    private final MimePart message;

    private static InputStream getInputStream(Part part, int n) throws MessagingException {
        try {
            InputStream inputStream2 = part.getInputStream();
            if (n == 0) {
                return new BufferedInputStream(inputStream2);
            }
            return new BufferedInputStream(inputStream2, n);
        }
        catch (IOException iOException) {
            throw new MessagingException("can't extract input stream: " + iOException);
        }
    }

    public SMIMEEnvelopedParser(MimeBodyPart mimeBodyPart) throws IOException, MessagingException, CMSException {
        this(mimeBodyPart, 0);
    }

    public SMIMEEnvelopedParser(MimeMessage mimeMessage) throws IOException, MessagingException, CMSException {
        this(mimeMessage, 0);
    }

    public SMIMEEnvelopedParser(MimeBodyPart mimeBodyPart, int n) throws IOException, MessagingException, CMSException {
        super(SMIMEEnvelopedParser.getInputStream((Part)mimeBodyPart, n));
        this.message = mimeBodyPart;
    }

    public SMIMEEnvelopedParser(MimeMessage mimeMessage, int n) throws IOException, MessagingException, CMSException {
        super(SMIMEEnvelopedParser.getInputStream((Part)mimeMessage, n));
        this.message = mimeMessage;
    }

    public MimePart getEncryptedContent() {
        return this.message;
    }
}

