/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import org.bouncycastle.cms.CMSCompressedDataParser;
import org.bouncycastle.cms.CMSException;

public class SMIMECompressedParser
extends CMSCompressedDataParser {
    private final MimePart message;

    private static InputStream getInputStream(Part part, int n) throws MessagingException {
        try {
            InputStream inputStream2 = part.getInputStream();
            if (n == 0) {
                return new BufferedInputStream(inputStream2);
            }
            return new BufferedInputStream(inputStream2, n);
        }
        catch (IOException iOException) {
            throw new MessagingException("can't extract input stream: " + iOException);
        }
    }

    public SMIMECompressedParser(MimeBodyPart mimeBodyPart) throws MessagingException, CMSException {
        this(mimeBodyPart, 0);
    }

    public SMIMECompressedParser(MimeMessage mimeMessage) throws MessagingException, CMSException {
        this(mimeMessage, 0);
    }

    public SMIMECompressedParser(MimeBodyPart mimeBodyPart, int n) throws MessagingException, CMSException {
        super(SMIMECompressedParser.getInputStream((Part)mimeBodyPart, n));
        this.message = mimeBodyPart;
    }

    public SMIMECompressedParser(MimeMessage mimeMessage, int n) throws MessagingException, CMSException {
        super(SMIMECompressedParser.getInputStream((Part)mimeMessage, n));
        this.message = mimeMessage;
    }

    public MimePart getCompressedContent() {
        return this.message;
    }
}

