/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.util;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLTaggedObject;

public class SignatureConverter {
    public static byte[] transferQ7Signature2P7Signature(byte[] q7) throws IOException {
        ASN1TaggedObject q7Content;
        ASN1Sequence q7Seq = ASN1Sequence.getInstance(q7);
        ASN1ObjectIdentifier q7contentType = (ASN1ObjectIdentifier)q7Seq.getObjectAt(0);
        if (!"1.2.840.113549.1.7.2".equals(q7contentType.getId()) && !"1.2.156.10197.6.1.4.2.2".equals(q7contentType.getId())) {
            throw new IOException("unsupported content type:" + q7contentType.getId());
        }
        if ("1.2.840.113549.1.7.2".equals(q7contentType.getId())) {
            return q7;
        }
        ASN1Encodable contentObject = q7Seq.getObjectAt(1);
        ASN1Sequence q7ContentSeq = null;
        boolean isExplicit = false;
        int tagNo = -1;
        if (contentObject instanceof DLTaggedObject) {
            q7Content = (DLTaggedObject)contentObject;
            q7ContentSeq = ASN1Sequence.getInstance(q7Content.getObject().getEncoded());
            tagNo = q7Content.getTagNo();
            isExplicit = q7Content.isExplicit();
        } else if (contentObject instanceof BERTaggedObject) {
            q7Content = (BERTaggedObject)q7Seq.getObjectAt(1);
            q7ContentSeq = ASN1Sequence.getInstance(q7Content.getObject().getEncoded());
            tagNo = q7Content.getTagNo();
            isExplicit = q7Content.isExplicit();
        } else {
            throw new IOException("unsupported type:" + contentObject.getClass().getName());
        }
        ASN1Encodable object0 = q7ContentSeq.getObjectAt(0);
        ASN1Encodable object1 = q7ContentSeq.getObjectAt(1);
        ASN1Sequence q7DataContent = (ASN1Sequence)q7ContentSeq.getObjectAt(2);
        ASN1Encodable object3 = q7ContentSeq.getObjectAt(3);
        ASN1Encodable object4 = q7ContentSeq.getObjectAt(4);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(new ASN1ObjectIdentifier("1.2.840.113549.1.7.1"));
        vector.add(q7DataContent.getObjectAt(1));
        DERSequence p7DataContent = new DERSequence(vector);
        vector = new ASN1EncodableVector();
        vector.add(object0);
        vector.add(object1);
        vector.add(p7DataContent);
        vector.add(object3);
        vector.add(object4);
        DERSequence p7ContentSeq = new DERSequence(vector);
        BERTaggedObject p7Content = new BERTaggedObject(isExplicit, tagNo, p7ContentSeq);
        ASN1ObjectIdentifier contentType = new ASN1ObjectIdentifier("1.2.840.113549.1.7.2");
        vector = new ASN1EncodableVector();
        vector.add(contentType);
        vector.add(p7Content);
        DERSequence p7Seq = new DERSequence(vector);
        return p7Seq.getEncoded();
    }
}

