/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.util;

import cn.unitid.easypki.asn1.sm2.application.SM2Cipher;
import cn.unitid.easypki.crypto.CipherException;
import cn.unitid.easypki.crypto.ECKeyGenerator;
import cn.unitid.easypki.crypto.SM2AsymmetricCipher;
import cn.unitid.easypki.crypto.SM4SymmetricCipher;
import cn.unitid.easypki.provider.asymmetric.sm2.SM2BCPublicKey;
import cn.unitid.easypki.security.SM4KeyGenerator;
import cn.unitid.easypki.util.CertificateConverter;
import cn.unitid.easypki.x509.SM2X509Certificate;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class EnvelopedPrivateKeyConverter {
    private PrivateKey buildCFCAPrivateKey(String hexPrivateKey) throws InvalidKeyException {
        byte[] privateKey = Hex.decode(hexPrivateKey);
        ASN1Sequence sequence = ASN1Sequence.getInstance(privateKey);
        DEROctetString prvOctetString = (DEROctetString)sequence.getObjectAt(1);
        BigInteger tempPrvUserD = new BigInteger(1, prvOctetString.getOctets());
        return ECKeyGenerator.generate(tempPrvUserD);
    }

    public static byte[] convertTopCA2SM2EnvelopedKey(String encryptedSymmKey, String encryptionCertificate, String symmCipherAlgorithm, String encryptedPrivateKey) throws CertificateException, IOException {
        Object ek = null;
        if (!"SM4".equals(symmCipherAlgorithm.toUpperCase())) {
            throw new IllegalArgumentException("unsupported cipher algorithm:" + symmCipherAlgorithm);
        }
        SM2X509Certificate ecert = SM2X509Certificate.decode(CertificateConverter.fromBase64(encryptionCertificate).getEncoded());
        AlgorithmIdentifier symAlgoID = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.104"));
        SM2Cipher symEncryptedKey = SM2Cipher.getInstance(Base64.decode(encryptedSymmKey));
        SM2BCPublicKey sm2PublicKey = (SM2BCPublicKey)ecert.getPublicKey();
        DERBitString sm2EncryptedPrivateKey = new DERBitString(Base64.decode(encryptedPrivateKey));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(symAlgoID);
        v.add(symEncryptedKey);
        v.add(new DERBitString(sm2PublicKey.getEncoded()));
        v.add(sm2EncryptedPrivateKey);
        DERSequence seq = new DERSequence(v);
        return seq.getEncoded();
    }

    public byte[] convertCFCA2SKFEncryptedPrivateKey(PublicKey encryptionPublicKey, String cfcaEncrytpionKey, String tempHexPrivateKey, PublicKey signaturePublicKey) throws InvalidKeyException, CipherException, IOException {
        byte[] encryptionPrivateKeyUserD = new byte[32];
        try {
            PrivateKey tempPrivateKey = this.buildCFCAPrivateKey(tempHexPrivateKey);
            SM2Cipher sm2Cipher = this.convertCFCAEncryptedPrivateKey2SM2Cipher(cfcaEncrytpionKey);
            SM2AsymmetricCipher cipher = new SM2AsymmetricCipher();
            cipher.init(2, tempPrivateKey);
            cipher.update(sm2Cipher.getEncoded());
            byte[] cfcaPrivateKeyBlob = cipher.doFinal();
            System.arraycopy(cfcaPrivateKeyBlob, 64, encryptionPrivateKeyUserD, 0, 32);
        }
        catch (CipherException e) {
            throw new CipherException("step0 \u89e3\u5bc6CFCA\u79c1\u94a5\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IOException("step0 \u6784\u9020SM2Cipher\u5f02\u5e38:" + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException("step0 \u6784\u9020\u4e34\u65f6\u79c1\u94a5\u9519\u8bef\uff1b" + e.getMessage(), e);
        }
        String symmKeyHex = SM4KeyGenerator.generate(1);
        byte[] symmKey = Hex.decode(symmKeyHex);
        byte[] encryptedPrivateKey = null;
        try {
            SM4SymmetricCipher sm4 = new SM4SymmetricCipher("ECB/NoPadding");
            sm4.init(1, symmKey);
            sm4.update(encryptionPrivateKeyUserD);
            encryptedPrivateKey = sm4.doFinal();
        }
        catch (Exception e) {
            throw new CipherException("step2 \u4f7f\u7528\u5bf9\u79f0\u5bc6\u94a5\u52a0\u5bc6\u52a0\u5bc6\u5bc6\u94a5\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        SM2BCPublicKey publicKey = (SM2BCPublicKey)encryptionPublicKey;
        ECPoint encryptionPointQ = publicKey.getQ();
        byte[] encryptionPublicKeyBlob = this.buildEncryptionPublicKeyBlob(encryptionPointQ);
        byte[] eccCipherBlob = null;
        try {
            SM2AsymmetricCipher cipher = new SM2AsymmetricCipher();
            cipher.init(1, signaturePublicKey);
            cipher.update(symmKey);
            byte[] symmCipherBinary = cipher.doFinal();
            SM2Cipher sm2Cipher = SM2Cipher.getInstance(symmCipherBinary);
            eccCipherBlob = this.buildECCCipherBlob(sm2Cipher);
        }
        catch (Exception e) {
            throw new CipherException("step4 \u4f7f\u7528\u7b7e\u540d\u516c\u94a5\u52a0\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        byte[] version = new byte[4];
        version[0] = 1;
        byte[] symmAlgID = new byte[4];
        symmAlgID[0] = 1;
        symmAlgID[1] = 4;
        byte[] byteBits = new byte[4];
        byteBits[1] = 1;
        byte[] skfEnvelopedKeyBlob = new byte[76 + encryptionPublicKeyBlob.length + eccCipherBlob.length];
        System.arraycopy(version, 0, skfEnvelopedKeyBlob, 0, 4);
        System.arraycopy(symmAlgID, 0, skfEnvelopedKeyBlob, 4, 4);
        System.arraycopy(byteBits, 0, skfEnvelopedKeyBlob, 8, 4);
        System.arraycopy(encryptedPrivateKey, 0, skfEnvelopedKeyBlob, 44, 32);
        System.arraycopy(encryptionPublicKeyBlob, 0, skfEnvelopedKeyBlob, 76, encryptionPublicKeyBlob.length);
        System.arraycopy(eccCipherBlob, 0, skfEnvelopedKeyBlob, 76 + encryptionPublicKeyBlob.length, eccCipherBlob.length);
        return skfEnvelopedKeyBlob;
    }

    private SM2Cipher convertCFCAEncryptedPrivateKey2SM2Cipher(String b64CFCACipherBlob) {
        ASN1Sequence cfcaSequence = ASN1Sequence.getInstance(Base64.decode(b64CFCACipherBlob));
        DEROctetString encOctectString = (DEROctetString)cfcaSequence.getObjectAt(1);
        byte[] cfcaCipherBlob = encOctectString.getOctets();
        byte[] xCoordinate = new byte[64];
        System.arraycopy(cfcaCipherBlob, 0, xCoordinate, 32, 32);
        byte[] yCoordinate = new byte[64];
        System.arraycopy(cfcaCipherBlob, 32, yCoordinate, 32, 32);
        byte[] hash = new byte[32];
        System.arraycopy(cfcaCipherBlob, 64, hash, 0, 32);
        byte[] cipher = new byte[96];
        System.arraycopy(cfcaCipherBlob, 96, cipher, 0, 96);
        return new SM2Cipher(new BigInteger(1, xCoordinate), new BigInteger(1, yCoordinate), hash, cipher);
    }

    private byte[] buildECCCipherBlob(SM2Cipher sm2Cipher) {
        byte[] c1x = this.get32Bytes(sm2Cipher.getXCoordinate().getPositiveValue().toByteArray());
        byte[] c1y = this.get32Bytes(sm2Cipher.getYCoordinate().getPositiveValue().toByteArray());
        byte[] hash = sm2Cipher.getHash().getOctets();
        byte[] cipherLen = new byte[4];
        byte[] cipher = sm2Cipher.getCipherText().getOctets();
        cipherLen[0] = (byte)cipher.length;
        byte[] eccCipherBlob = new byte[164 + cipher.length];
        System.arraycopy(c1x, 0, eccCipherBlob, 32, 32);
        System.arraycopy(c1y, 0, eccCipherBlob, 96, 32);
        System.arraycopy(hash, 0, eccCipherBlob, 128, 32);
        System.arraycopy(cipherLen, 0, eccCipherBlob, 160, 4);
        System.arraycopy(cipher, 0, eccCipherBlob, 164, cipher.length);
        return eccCipherBlob;
    }

    private byte[] buildEncryptionPublicKeyBlob(ECPoint encryptionPointQ) {
        byte[] bitLength = new byte[4];
        bitLength[1] = 1;
        byte[] x = this.get32Bytes(encryptionPointQ.getAffineXCoord().toBigInteger().toByteArray());
        byte[] y = this.get32Bytes(encryptionPointQ.getAffineYCoord().toBigInteger().toByteArray());
        byte[] encryptionPublicKeyBlob = new byte[132];
        System.arraycopy(bitLength, 0, encryptionPublicKeyBlob, 0, 4);
        System.arraycopy(x, 0, encryptionPublicKeyBlob, 36, 32);
        System.arraycopy(y, 0, encryptionPublicKeyBlob, 100, 32);
        return encryptionPublicKeyBlob;
    }

    private byte[] get32Bytes(byte[] data) {
        byte[] data32 = new byte[32];
        int length = data.length;
        if (length > 32) {
            System.arraycopy(data, length - 32, data32, 0, 32);
        } else if (length < 32) {
            System.arraycopy(data, 0, data32, 0, length);
        } else {
            data32 = data;
        }
        return data32;
    }
}

