/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.security.sm2;

import cn.unitid.easypki.asn1.sm2.application.SM2Signature;
import cn.unitid.easypki.security.ec.ECDomainParametersHelper;
import cn.unitid.easypki.security.sm2.SM2Result;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2 {
    BigInteger ecc_p = ECDomainParametersHelper.ecc_p;
    BigInteger ecc_a = ECDomainParametersHelper.ecc_a;
    BigInteger ecc_b = ECDomainParametersHelper.ecc_b;
    BigInteger ecc_n = ECDomainParametersHelper.ecc_n;
    BigInteger ecc_gx = ECDomainParametersHelper.ecc_gx;
    BigInteger ecc_gy = ECDomainParametersHelper.ecc_gy;
    ECCurve ecc_curve = ECDomainParametersHelper.getECCurve();
    ECPoint ecc_point_g = ECDomainParametersHelper.getECPointG();
    private AsymmetricCipherKeyPair keyPair;

    public void presetTemporaryKeyPair(AsymmetricCipherKeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public byte[] sm2GetZ(byte[] userId, ECPoint userKey) {
        return this.sm2GetZ(userId, userKey.getAffineXCoord().toBigInteger(), userKey.getAffineYCoord().toBigInteger());
    }

    private byte[] sm2GetZ(byte[] userId, BigInteger x, BigInteger y) {
        SM3Digest sm3 = new SM3Digest();
        int len = userId.length * 8;
        sm3.update((byte)(len >> 8 & 0xFF));
        sm3.update((byte)(len & 0xFF));
        sm3.update(userId, 0, userId.length);
        byte[] p = this.ecc_a.toByteArray();
        sm3.update(p, 0, p.length);
        p = this.ecc_b.toByteArray();
        sm3.update(p, 0, p.length);
        p = this.ecc_gx.toByteArray();
        sm3.update(p, 0, p.length);
        p = this.ecc_gy.toByteArray();
        sm3.update(p, 0, p.length);
        p = x.toByteArray();
        sm3.update(p, 0, p.length);
        p = y.toByteArray();
        sm3.update(p, 0, p.length);
        byte[] md = new byte[sm3.getDigestSize()];
        sm3.doFinal(md, 0);
        return md;
    }

    private AsymmetricCipherKeyPair generateTemporaryKeyPair() {
        ECDomainParameters ecDomainParameters = ECDomainParametersHelper.getECDomainParameters();
        ECKeyGenerationParameters kenGenParam = new ECKeyGenerationParameters(ecDomainParameters, new SecureRandom());
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init(kenGenParam);
        return keyPairGenerator.generateKeyPair();
    }

    public void sm2Sign(byte[] md, BigInteger userD, SM2Result sm2Ret) {
        BigInteger e = new BigInteger(1, md);
        BigInteger k = null;
        ECPoint kp = null;
        BigInteger r = null;
        BigInteger s = null;
        int keyLoop = 0;
        while (true) {
            AsymmetricCipherKeyPair keyPair = null;
            keyPair = keyLoop == 0 ? (this.keyPair == null ? this.generateTemporaryKeyPair() : this.keyPair) : this.generateTemporaryKeyPair();
            ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keyPair.getPrivate();
            ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keyPair.getPublic();
            k = ecpriv.getD();
            kp = ecpub.getQ();
            r = e.add(kp.getXCoord().toBigInteger());
            r = r.mod(this.ecc_n);
            ++keyLoop;
            if (r.equals(BigInteger.ZERO) || r.add(k).equals(this.ecc_n)) continue;
            BigInteger da_1 = userD.add(BigInteger.ONE);
            da_1 = da_1.modInverse(this.ecc_n);
            s = r.multiply(userD);
            s = k.subtract(s).mod(this.ecc_n);
            if (!(s = da_1.multiply(s).mod(this.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        sm2Ret.r = r;
        sm2Ret.s = s;
    }

    public void sm2Verify(byte[] md, ECPoint ecPointQ, SM2Signature sm2Signature, SM2Result sm2Ret) {
        sm2Ret.R = null;
        BigInteger r = sm2Signature.getR().getValue();
        BigInteger s = sm2Signature.getS().getValue();
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(this.ecc_n);
        if (t.equals(BigInteger.ZERO)) {
            return;
        }
        ECPoint x1y1 = this.ecc_point_g.multiply(s);
        x1y1 = x1y1.add(ecPointQ.multiply(t));
        sm2Ret.R = e.add(x1y1.normalize().getXCoord().toBigInteger()).mod(this.ecc_n);
    }
}

