/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.security;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EPHMac {
    private HMac hMac;

    private EPHMac(HMac hMac) {
        this.hMac = hMac;
    }

    public static EPHMac getInstance(String algorithmIdentifier) throws NoSuchAlgorithmException {
        HMac hMac;
        if (algorithmIdentifier == null) {
            throw new NullPointerException();
        }
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        switch (algorithmIdentifier) {
            case "1.2.840.113549.2.7": {
                hMac = new HMac(new SHA1Digest());
                break;
            }
            case "1.2.156.10197.1.401.2": {
                hMac = new HMac(new SM3Digest());
                break;
            }
            case "1.2.840.113549.2.9": {
                hMac = new HMac(new SHA256Digest());
                break;
            }
            case "1.2.840.113549.2.10": {
                hMac = new HMac(new SHA384Digest());
                break;
            }
            case "1.2.840.113549.2.11": {
                hMac = new HMac(new SHA512Digest());
                break;
            }
            case "1.3.6.1.5.5.8.1.1": {
                hMac = new HMac(new MD5Digest());
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("algorithm " + algorithmIdentifier + " not supported");
            }
        }
        return new EPHMac(hMac);
    }

    public void init(byte[] key) {
        KeyParameter keyParameter = new KeyParameter(key);
        this.hMac.init(keyParameter);
    }

    public void init(CipherParameters cipherParameters) {
        this.hMac.init(cipherParameters);
    }

    public void reset() {
        this.hMac.reset();
    }

    public void update(byte data) {
        this.hMac.update(data);
    }

    public void update(byte[] data) {
        this.hMac.update(data, 0, data.length);
    }

    public void update(byte[] data, int n, int length) {
        this.hMac.update(data, n, length);
    }

    public byte[] doFinal() {
        byte[] out = new byte[this.hMac.getMacSize()];
        this.hMac.doFinal(out, 0);
        this.hMac.reset();
        return out;
    }
}

