/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.provider.identifier;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EPAlgorithmIdentifier {
    public static final String SHA1_WITH_DSA = "SHA1withDSA";
    public static final String SHA1_WITH_RSA = "SHA1withRSA";
    public static final String SHA1_WITH_RSA_ENCRYPTION = "SHA1WITHRSAENCRYPTION";
    public static final String SHA256_WITH_RSA = "SHA256withRSA";
    public static final String SHA384_WITH_RSA = "SHA384withRSA";
    public static final String SHA512_WITH_RSA = "SHA512withRSA";
    public static final String MD5_WITH_RSA = "MD5withRSA";
    public static final String ECDSA_SM2_WITH_SM3 = "ECDSASM2withSM3";
    public static final String SHA256_ALGORITHM_OID = "2.16.840.1.101.3.4.2.1";
    public static final String SHA384_ALGORITHM_OID = "2.16.840.1.101.3.4.2.2";
    public static final String SHA512_ALGORITHM_OID = "2.16.840.1.101.3.4.2.3";
    public static final String SHA1_ALGORITHM_OID = "1.3.14.3.2.26";
    public static final String MD5_ALGORITHM_OID = "1.2.840.113549.2.5";
    public static final String RSA_ALGORITHM_OID = "1.2.840.113549.1.1.1";
    public static final String DSA_ALGORITHM_OID = "1.2.840.10040.4.1";
    public static final String SHA1_WITH_RSA_ENCRYPTION_ALGORITHM_OID = "1.2.840.113549.1.1.5";
    public static final String SHA256_WITH_RSA_ENCRYPTION_ALGORITHM_OID = "1.2.840.113549.1.1.11";
    public static final String MD5_WITH_RSA_ENCRYPTION_ALGORITHM_OID = "1.2.840.113549.1.1.4";
    public static final String SHA1_WITH_DSA_ENCRYPTION_ALGORITHM_OID = "1.2.840.10040.4.3";
    public static final String HMAC_SHA1_ALGORITHM_OID = "1.2.840.113549.2.7";
    public static final String HMAC_SHA256_ALGORITHM_OID = "1.2.840.113549.2.9";
    public static final String HMAC_SHA384_ALGORITHM_OID = "1.2.840.113549.2.10";
    public static final String HMAC_SHA512_ALGORITHM_OID = "1.2.840.113549.2.11";
    public static final String HMAC_MD5_ALGORITHM_OID = "1.3.6.1.5.5.8.1.1";
    public static final String HMAC_SM3_ALGORITHM_OID = "1.2.156.10197.1.401.2";
    public static final String SM1_ALGORITHM_OID = "1.2.156.10197.1.102";
    public static final String SM2_ALGORITHM_OID = "1.2.156.10197.1.301";
    public static final String SM2_1_DIGITAL_SIGNATURE_ALGORITHM_OID = "1.2.156.10197.1.301.1";
    public static final String SM2_2_KEY_EXCHANGE_PROTOCOL_ALGORITHM_OID = "1.2.156.10197.1.301.2";
    public static final String SM2_3_PUBLIC_KEY_ENCRYPT_ALGORITHM_OID = "1.2.156.10197.1.301.3";
    public static final String SM4_ALGORITHM_OID = "1.2.156.10197.1.104";
    public static final String SM4_ALGORITHM_OID_CBC = "1.2.156.10197.1.104.1.4";
    public static final String SM4_ALGORITHM_OID_ECB = "1.2.156.10197.1.104.1.3";
    public static final String SM2_ALGORITHM_IN_PKCS7_OID = "1.2.156.10197.1.301.1";
    public static final String SM3_ALGORITHM_OID = "1.2.156.10197.1.401";
    public static final String EC_PUBLIC_KEY_OID = "1.2.840.10045.2.1";
    public static final String SM2_SIGNATURE_ALGORITHM_OID = "1.2.156.10197.1.501";
    public static final String SM3_WITH_SM2_ENCRYPTION_ALGORITHM_OID = "1.2.156.10197.1.501";
    public static final String PKCS7_DATA_OID = "1.2.840.113549.1.7.1";
    public static final String PKCS7_SM2_DATA_OID = "1.2.156.10197.6.1.4.2.1";
    public static final String PKCS7_SIGNED_DATA_OID = "1.2.840.113549.1.7.2";
    public static final String PKCS7_SM2_SIGNED_DATA_OID = "1.2.156.10197.6.1.4.2.2";
    public static final String PKCS7_SM2_ENVELOPED_DATA_OID = "1.2.156.10197.6.1.4.2.3";
    public static final AlgorithmIdentifier SHA1_WITH_RSA_ENCRYPTION_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"), DERNull.INSTANCE);
    public static final AlgorithmIdentifier SHA256_WITH_RSA_ENCRYPTION_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.11"), DERNull.INSTANCE);
    public static final AlgorithmIdentifier MD5_WITH_RSA_ENCRYPTION_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.4"), DERNull.INSTANCE);
    public static final AlgorithmIdentifier SM3_WITH_SM2_ENCRYPTION_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.501"), DERNull.INSTANCE);
    public static final AlgorithmIdentifier RSA_PUBLIC_KEY_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.1"), DERNull.INSTANCE);
    public static final AlgorithmIdentifier SM2_PUBLIC_KEY_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.10045.2.1"), new ASN1ObjectIdentifier("1.2.156.10197.1.301"));
    public static final AlgorithmIdentifier SM1_SYM_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.102"));
    public static final AlgorithmIdentifier SM3_HASH_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.401"));
    public static final AlgorithmIdentifier SM4_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.104"));
    private static Map<String, String> algorithmMap = new HashMap<String, String>();

    public static boolean hasAlgorithm(String algorithm) {
        return algorithmMap.containsKey(algorithm.toUpperCase());
    }

    public static String getAlgorithmName(String oid) {
        return algorithmMap.get(oid);
    }

    static {
        algorithmMap.put(SHA1_ALGORITHM_OID, "sha1");
        algorithmMap.put(MD5_ALGORITHM_OID, "md5");
        algorithmMap.put(SHA256_ALGORITHM_OID, "sha256");
        algorithmMap.put(SHA384_ALGORITHM_OID, "sha384");
        algorithmMap.put(SHA512_ALGORITHM_OID, "sha512");
        algorithmMap.put(RSA_ALGORITHM_OID, "rsa");
        algorithmMap.put(SM2_ALGORITHM_OID, "sm2");
        algorithmMap.put(SM3_ALGORITHM_OID, "sm3");
        algorithmMap.put(MD5_WITH_RSA_ENCRYPTION_ALGORITHM_OID, "md5WithRSA");
        algorithmMap.put(SHA1_WITH_RSA_ENCRYPTION_ALGORITHM_OID, "sha1WithRSA");
        algorithmMap.put(SHA256_WITH_RSA_ENCRYPTION_ALGORITHM_OID, "sha256WithRSA");
        algorithmMap.put(SHA1_WITH_DSA.toUpperCase(), SHA1_WITH_DSA);
        algorithmMap.put(SHA1_WITH_RSA_ENCRYPTION.toUpperCase(), SHA1_WITH_RSA);
        algorithmMap.put(SHA1_WITH_RSA.toUpperCase(), SHA1_WITH_RSA);
        algorithmMap.put(SHA256_WITH_RSA.toUpperCase(), SHA256_WITH_RSA);
        algorithmMap.put(SHA384_WITH_RSA.toUpperCase(), SHA384_WITH_RSA);
        algorithmMap.put(SHA512_WITH_RSA.toUpperCase(), SHA512_ALGORITHM_OID);
        algorithmMap.put(MD5_WITH_RSA.toUpperCase(), MD5_WITH_RSA);
        algorithmMap.put(ECDSA_SM2_WITH_SM3.toUpperCase(), ECDSA_SM2_WITH_SM3);
        algorithmMap.put("1.2.156.10197.1.501", "1.2.156.10197.1.501");
    }
}

