/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.crypto;

import cn.unitid.easypki.crypto.CipherException;
import cn.unitid.easypki.crypto.SymmetricCipher;
import cn.unitid.easypki.security.sm4.SM4;
import cn.unitid.easypki.security.sm4.SM4Context;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;

public class SM4SymmetricCipher
implements SymmetricCipher {
    public static final String ECB = "ECB";
    public static final String ECB_NO_PADDING = "ECB/NoPadding";
    public static final String CBC = "CBC";
    public static final String CBC_NO_PADDING = "CBC/NoPadding";
    private int mode;
    private String transformation;
    private byte[] symmetricKey;
    private byte[] iv = "0000000000000000".getBytes();
    private byte[] data = null;
    private boolean padding = true;

    public SM4SymmetricCipher(String transformation) {
        if (ECB.equalsIgnoreCase(transformation)) {
            this.transformation = ECB;
        } else if (CBC.equalsIgnoreCase(transformation)) {
            this.transformation = CBC;
        } else if (ECB_NO_PADDING.equalsIgnoreCase(transformation)) {
            this.transformation = ECB;
            this.padding = false;
        } else if (CBC_NO_PADDING.equalsIgnoreCase(transformation)) {
            this.transformation = CBC;
            this.padding = false;
        } else {
            throw new InvalidParameterException("\u8be5\u8f6c\u6362\u6a21\u5f0f\u4e0d\u652f\u6301\uff1a" + transformation);
        }
    }

    private SM4SymmetricCipher() {
    }

    @Override
    public void init(int opmode, byte[] symmKey) throws InvalidKeyException {
        this.init(opmode, symmKey, null);
    }

    @Override
    public void init(int opmode, byte[] symmKey, byte[] iv) throws InvalidKeyException {
        if (opmode != 1 && opmode != 2) {
            throw new InvalidParameterException("\u65e0\u6548\u7684\u64cd\u4f5c\u6a21\u5f0f\uff1a" + opmode);
        }
        if (symmKey == null) {
            throw new InvalidKeyException("\u5bf9\u79f0\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.mode = opmode;
        this.symmetricKey = symmKey;
        if (iv != null) {
            this.iv = iv;
        }
    }

    @Override
    public void update(byte[] data) {
        if (data == null) {
            throw new NullPointerException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (this.data == null) {
            this.data = (byte[])data.clone();
        } else {
            byte[] newData = new byte[this.data.length + data.length];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            System.arraycopy(data, 0, newData, this.data.length, data.length);
            this.data = newData;
        }
    }

    @Override
    public byte[] doFinal() throws CipherException {
        byte[] finalData = null;
        if (this.symmetricKey == null) {
            throw new CipherException("symmetric key is not initialized");
        }
        if (this.data == null) {
            throw new CipherException("no data found");
        }
        SM4Context context = new SM4Context();
        context.mode = this.mode == 1 ? 1 : 0;
        context.isPadding = this.padding;
        try {
            SM4 sm4 = new SM4();
            sm4.setKey(context, this.symmetricKey);
            finalData = this.transformation.equals(ECB) ? sm4.cryptWithECB(context, this.data) : sm4.cryptWithCBC(context, this.iv, this.data);
        }
        catch (InvalidKeyException e) {
            throw new CipherException(e.getMessage(), e);
        }
        catch (Exception e) {
            String operation = this.mode == 1 ? "\u52a0\u5bc6" : "\u89e3\u5bc6";
            throw new CipherException(operation + "\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        return finalData;
    }
}

