/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.crypto;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class ByteConverter {
    public static byte[] convertTo32Bytes(BigInteger n) {
        byte[] tmpd = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmpd, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmpd = n.toByteArray();
        } else {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 0, tmpd, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmpd;
    }

    public static byte[] convertToBigEndian(byte[] littleEndianBytes) {
        int value = ByteConverter.convertBigEndianBytesToInt(littleEndianBytes);
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    public static int convertBigEndianBytesToInt(byte[] littleEndianBytes) {
        return ByteBuffer.wrap(littleEndianBytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }
}

