/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.asn1.sm2.application;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class SM2Signature
extends ASN1Object {
    private ASN1Integer r;
    private ASN1Integer s;
    private boolean allow_unsafe_integer = false;

    public SM2Signature(ASN1Integer r, ASN1Integer s) {
        this.r = r;
        this.s = s;
    }

    public SM2Signature(byte[] r, byte[] s) {
        this.r = new ASN1Integer(new BigInteger(1, r));
        this.s = new ASN1Integer(new BigInteger(1, s));
    }

    private SM2Signature(ASN1Sequence seq) {
        this.r = new ASN1Integer(ASN1Integer.getInstance(seq.getObjectAt(0)).getPositiveValue());
        this.s = new ASN1Integer(ASN1Integer.getInstance(seq.getObjectAt(1)).getPositiveValue());
    }

    public static SM2Signature getInstance(Object o) {
        try {
            if (o instanceof SM2Signature) {
                return (SM2Signature)o;
            }
            if (o instanceof ASN1Sequence) {
                return new SM2Signature(ASN1Sequence.getInstance(o));
            }
            if (o instanceof byte[]) {
                return new SM2Signature(ASN1Sequence.getInstance(o));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public ASN1Integer getR() {
        return this.r;
    }

    public ASN1Integer getS() {
        return this.s;
    }

    public byte[] getByteR() {
        return this.processASN1Integer(this.r);
    }

    public byte[] getByteS() {
        return this.processASN1Integer(this.s);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.r);
        v.add(this.s);
        return new DERSequence(v);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        byte[] asnSignature = null;
        if (this.allow_unsafe_integer) {
            byte[] asnR = this.format(this.r.getPositiveValue().toByteArray());
            byte[] asnS = this.format(this.s.getPositiveValue().toByteArray());
            int rLength = asnR.length;
            int sLength = asnS.length;
            asnSignature = new byte[rLength + sLength + 2];
            asnSignature[0] = 48;
            asnSignature[1] = (byte)(rLength + sLength);
            System.arraycopy(asnR, 0, asnSignature, 2, rLength);
            System.arraycopy(asnS, 0, asnSignature, rLength + 2, sLength);
        } else {
            asnSignature = this.toASN1Primitive().getEncoded();
        }
        return asnSignature;
    }

    private byte[] format(byte[] value) {
        int length = value.length;
        int copyPosition = 2;
        byte[] asnBinary = null;
        if (length <= 31) {
            copyPosition = 34 - value.length;
            asnBinary = new byte[34];
            asnBinary[0] = 2;
            asnBinary[1] = 32;
        } else {
            asnBinary = new byte[length + 2];
            asnBinary[0] = 2;
            asnBinary[1] = (byte)length;
        }
        System.arraycopy(value, 0, asnBinary, copyPosition, length);
        return asnBinary;
    }

    public String toString() {
        String TAB = "\n\t";
        StringBuilder buff = new StringBuilder("SM2Signature::{\n\t");
        buff.append("r=");
        buff.append(Hex.toHexString(this.getByteR()));
        buff.append(TAB);
        buff.append("s=");
        buff.append(Hex.toHexString(this.getByteS()));
        buff.append("\n}");
        return buff.toString();
    }

    private byte[] processASN1Integer(ASN1Integer num) {
        byte[] value = num.getPositiveValue().toByteArray();
        byte[] rv = new byte[32];
        if (31 >= value.length) {
            System.arraycopy(value, 0, rv, 32 - value.length, value.length);
        } else if (32 == value.length) {
            rv = value;
        } else if (33 == value.length) {
            System.arraycopy(value, 1, rv, 0, 32);
        } else {
            throw new IllegalStateException("R or S`s byte length must be 32 or 33 !");
        }
        return rv;
    }

    public void enableUnsafeInteger(boolean enable) {
        this.allow_unsafe_integer = enable;
    }

    public static void main(String[] args2) throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] s = Base64.decode("MEUCIAAsqp3BV0Auf8Kzw/200d2sMuz903B7A31Fpc6EHnGmAiEAlU5Xc+BJsIuWGlEoNQCTAh6XemXlc+oi3A4NXs8sYt0=");
        ASN1Sequence sequence = ASN1Sequence.getInstance(s);
        System.out.println(1);
    }
}

