/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.asn1.rsa;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class RSAEnvelopedKey
implements ASN1Encodable {
    private DERBitString symEncryptedKey;
    private DERBitString encryptedPrivateKey;
    private AlgorithmIdentifier symAlgoID;

    public static RSAEnvelopedKey getInstance(ASN1Sequence sequence) {
        return new RSAEnvelopedKey(sequence);
    }

    private RSAEnvelopedKey(ASN1Sequence sequence) {
        this.symAlgoID = AlgorithmIdentifier.getInstance(sequence.getObjectAt(0));
        this.symEncryptedKey = DERBitString.getInstance(sequence.getObjectAt(1));
        this.encryptedPrivateKey = DERBitString.getInstance(sequence.getObjectAt(2));
    }

    public AlgorithmIdentifier getSymAlgoID() {
        return this.symAlgoID;
    }

    public DERBitString getSymEncryptedKey() {
        return this.symEncryptedKey;
    }

    public DERBitString getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.symAlgoID);
        v.add(this.symEncryptedKey);
        v.add(this.encryptedPrivateKey);
        return new DERSequence(v);
    }
}

