/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.utils;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AesUtils {
    private static final String KEY_ALGORITHM = "AES";
    static Charset charset = Charset.forName("UTF-8");
    private static final String SHA1PRNG = "SHA1PRNG";
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static String encrypt(String data, SecretKey secretKey) throws Exception {
        byte[] result = AesUtils.aes(data.getBytes(), 1, secretKey);
        return Base64.getEncoder().encodeToString(result);
    }

    public static String decryptByPassword(String keyStr, String data) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyStr.getBytes(), KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, key);
        byte[] result = cipher.doFinal(Base64.getDecoder().decode(data));
        return new String(result);
    }

    public static String decrypt(String data, SecretKey secretKey) throws Exception {
        byte[] result = AesUtils.aes(Base64.getDecoder().decode(data), 2, secretKey);
        return new String(result, charset);
    }

    public static SecretKey generateKey(String password) throws NoSuchAlgorithmException {
        KeyGenerator secretGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        SecureRandom secureRandom = SecureRandom.getInstance(SHA1PRNG);
        secureRandom.setSeed(password.getBytes());
        secretGenerator.init(128, secureRandom);
        SecretKey secretKey = secretGenerator.generateKey();
        return secretKey;
    }

    private static byte[] aes(byte[] contentArray, int mode, SecretKey secretKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(mode, secretKey);
        return cipher.doFinal(contentArray);
    }
}

