/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.request.sop.svs;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.BaseApiRequest;
import cn.unitid.cip.sdk.constant.Algorithm;
import cn.unitid.cip.sdk.constant.CryptogramEngineType;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.response.sop.svs.SvsApplySecretResponse;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class KeyPairGenerateRequest
extends BaseApiRequest<SvsApplySecretResponse> {
    private Integer keySize;
    private CryptogramEngineType cryptogramEngineType;
    private Algorithm algorithm;
    private String privateKey;
    private String publicKey;

    public String getServiceType() {
        return "svs";
    }

    @Override
    public String getApiMethodName() {
        return "get-secret";
    }

    @Override
    public String getApiModel() {
        return "svs";
    }

    @Override
    public Map<String, String> getTextParams() {
        ApiHashMap params = new ApiHashMap();
        if (this.keySize != null) {
            params.put("keySize", (Object)this.keySize);
        }
        if (this.cryptogramEngineType != null) {
            params.put("cryptogramEngineType", this.cryptogramEngineType.toString());
        }
        if (this.algorithm != null) {
            params.put("algorithm", this.algorithm.toString());
        }
        if (StringUtils.isNotEmpty(this.privateKey)) {
            params.put("privateKey", this.privateKey);
            params.put("publicKey", this.publicKey);
        }
        if (this.udfParams != null) {
            params.putAll(this.udfParams);
        }
        return params;
    }

    @Override
    public Class<SvsApplySecretResponse> getResponseClass() {
        return SvsApplySecretResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
    }

    @Override
    public String getExecuteMethod() {
        return "POST";
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    public CryptogramEngineType getCryptogramEngineType() {
        return this.cryptogramEngineType;
    }

    public void setCryptogramEngineType(CryptogramEngineType cryptogramEngineType) {
        this.cryptogramEngineType = cryptogramEngineType;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }
}

