/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.request.sop.personal;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.BaseApiRequest;
import cn.unitid.cip.sdk.dto.cert.AgentInfo;
import cn.unitid.cip.sdk.dto.cert.PersonalSeniorCertificate;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.internal.util.RequestCheckUtils;
import cn.unitid.cip.sdk.response.sop.personal.PersonalIssueResponse;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PersonalIssueRequest
extends BaseApiRequest<PersonalIssueResponse> {
    private PersonalSeniorCertificate personalSeniorCertificate;
    private String pkCS10;
    private Map<String, String> extensions;
    private AgentInfo agentInfo;
    private String extend;
    private String password;
    private String keyId;

    @Override
    public String getApiMethodName() {
        return "issue";
    }

    @Override
    public String getApiModel() {
        return "cert";
    }

    @Override
    public Map<String, String> getTextParams() {
        ApiHashMap txtParams = new ApiHashMap();
        txtParams.put("pkCS10", this.pkCS10);
        txtParams.put("extend", this.extend);
        txtParams.put("password", this.password);
        if (StringUtils.isNotBlank(this.keyId)) {
            txtParams.put("keyId", this.keyId);
        }
        if (null != this.personalSeniorCertificate) {
            txtParams.putAll(this.personalSeniorCertificate.getMapParam(""));
        }
        if (this.extensions != null) {
            for (Map.Entry<String, String> entry : this.extensions.entrySet()) {
                txtParams.put("extensions[" + entry.getKey() + "]", entry.getValue());
            }
        }
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        if (this.agentInfo != null) {
            txtParams.putAll(this.agentInfo.getMapParam("agentInfo."));
        }
        return txtParams;
    }

    @Override
    public Class<PersonalIssueResponse> getResponseClass() {
        return PersonalIssueResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.pkCS10, "pkCS10");
        this.personalSeniorCertificate.setExtend(this.pkCS10);
        this.personalSeniorCertificate.check();
        if (this.agentInfo != null) {
            this.agentInfo.check();
        }
    }

    @Override
    public String getExecuteMethod() {
        return "POST";
    }

    public void setPersonalSeniorCertificate(PersonalSeniorCertificate personalSeniorCertificate) {
        this.personalSeniorCertificate = personalSeniorCertificate;
    }

    public void setPkCS10(String pkCS10) {
        this.pkCS10 = pkCS10;
    }

    public void setExtensions(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    public PersonalSeniorCertificate getPersonalSeniorCertificate() {
        return this.personalSeniorCertificate;
    }

    public String getPkCS10() {
        return this.pkCS10;
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public void setAgentInfo(AgentInfo agentInfo) {
        this.agentInfo = agentInfo;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }
}

