/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.internal.util;

import cn.unitid.cip.sdk.internal.util.ApiUtils;
import cn.unitid.cip.sdk.internal.util.StringUtils;
import cn.unitid.cip.sdk.internal.util.WebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApiLogger {
    private static final Log log = LogFactory.getLog("apisdk");
    private static final String LOG_SPLIT = "^_^";
    private static String osName = System.getProperties().getProperty("os.name");
    private static boolean needEnableLogger = true;

    public static void setNeedEnableLogger(boolean needEnableLogger) {
        ApiLogger.needEnableLogger = needEnableLogger;
    }

    public static void logApiError(String appKey, String apiName, String url, Map<String, String> params, long latency, String errorMessage) {
        if (!needEnableLogger) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ApiLogger.formatDateTime(new Date()));
        sb.append(LOG_SPLIT);
        sb.append(appKey);
        sb.append(LOG_SPLIT);
        sb.append(apiName);
        sb.append(LOG_SPLIT);
        sb.append(ApiUtils.getIntranetIp());
        sb.append(LOG_SPLIT);
        sb.append(osName);
        sb.append(LOG_SPLIT);
        sb.append(latency);
        sb.append(LOG_SPLIT);
        sb.append(url);
        try {
            sb.append(LOG_SPLIT);
            sb.append(WebUtils.buildQuery(params, "utf-8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sb.append(LOG_SPLIT);
        sb.append(errorMessage);
        log.error(sb.toString());
    }

    private static String formatDateTime(Date date) {
        return StringUtils.formatDateTime(date, "yyyy-MM-dd HH:mm:ss.SSS");
    }
}

