/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.dto.cert;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.constant.IdType;
import cn.unitid.cip.sdk.dto.cert.BaseCertificate;
import cn.unitid.cip.sdk.internal.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PersonalSeniorCertificate
extends BaseCertificate {
    private static final long serialVersionUID = 7749725183346501001L;
    private IdType idType;
    private String idNumber;
    private String phoneNumber;
    private String ownerName;
    private String certificateType = "PERSONAL_SENIOR";

    @Override
    public Map<String, String> getMapParam(String param) {
        HashMap<String, String> mapParam = new HashMap<String, String>(10);
        mapParam.putAll(super.getMapParam(param));
        if (this.idType != null) {
            mapParam.put(param + "idType", this.idType.toString());
        }
        if (!StringUtils.isEmpty(this.getIdNumber())) {
            mapParam.put(param + "idNumber", this.getIdNumber());
        }
        if (!StringUtils.isEmpty(this.getPhoneNumber())) {
            mapParam.put(param + "phoneNumber", this.getPhoneNumber());
        }
        if (!StringUtils.isEmpty(this.getOwnerName())) {
            mapParam.put(param + "ownerName", this.getOwnerName());
        }
        if (!StringUtils.isEmpty(this.getCertificateType())) {
            mapParam.put(param + "certificateType", this.getCertificateType());
            mapParam.put("certificateType", this.getCertificateType());
        }
        return mapParam;
    }

    @Override
    public void check() throws ApiRuleException {
    }

    @Override
    public Date getNotBefore() {
        if (super.getNotBefore() == null) {
            this.setNotBefore(new Date());
        }
        return super.getNotBefore();
    }

    @Override
    public Date getNotAfter() {
        if (super.getNotAfter() == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, calendar.get(1) + 1);
            this.setNotAfter(calendar.getTime());
        }
        return super.getNotAfter();
    }

    public void setIdType(IdType idType) {
        this.idType = idType;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public String getCertificateType() {
        return this.certificateType;
    }
}

