/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk;

import cn.unitid.cip.sdk.ApiClient;
import cn.unitid.cip.sdk.ApiException;
import cn.unitid.cip.sdk.ApiParser;
import cn.unitid.cip.sdk.ApiRequest;
import cn.unitid.cip.sdk.ApiResponse;
import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.ApiUploadRequest;
import cn.unitid.cip.sdk.internal.parser.json.ObjectJsonParser;
import cn.unitid.cip.sdk.internal.parser.xml.ObjectXmlParser;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.internal.util.ApiLogger;
import cn.unitid.cip.sdk.internal.util.ApiUtils;
import cn.unitid.cip.sdk.internal.util.RandomStringUtils;
import cn.unitid.cip.sdk.internal.util.RequestParametersHolder;
import cn.unitid.cip.sdk.internal.util.StringUtils;
import cn.unitid.cip.sdk.internal.util.WebUtils;
import cn.unitid.cip.sdk.utils.AesUtils;
import cn.unitid.cip.sdk.utils.SM4Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultApiClient
implements ApiClient {
    protected String serverUrl;
    protected Integer regainTime = 3;
    protected Map<String, String> serverUrlMap = new HashMap<String, String>();
    protected Map<String, String> locationUrlMap = new HashMap<String, String>();
    protected Map<String, String> standbyUrlMap = new HashMap<String, String>();
    protected Map<String, String> reserveUrlMap = new HashMap<String, String>();
    protected Map<String, String> disLocationUrlMap = new HashMap<String, String>();
    protected Map<String, String> disStandbyUrlMap = new HashMap<String, String>();
    protected Map<String, String> disReserveUrlMap = new HashMap<String, String>();
    protected String location;
    protected Integer pos = 0;
    protected List<String> reserveLocation;
    protected String appKey;
    protected String appSecret;
    protected String format = "json";
    protected String signMethod = "HMAC-SHA256";
    private static final Log log = LogFactory.getLog("apiClient");
    private OkHttpClient client;
    protected int connectTimeout = 5000;
    protected int readTimeout = 5000;
    protected int writeTimeout = 15000;
    protected int maxIdleConnections = 10;
    protected long keepAliveDuration = 60L;
    protected boolean needCheckRequest = true;
    protected boolean needEnableParser = true;
    protected boolean useSimplifyJson = false;
    protected boolean useGzipEncoding = false;
    protected String encMethod = "AES";
    protected boolean encryptionEnable = false;

    public DefaultApiClient(Map<String, String> serverUrlMap, String location, List<String> reserveLocation, String appKey, String appSecret) throws ApiException {
        this.setServerUrl(serverUrlMap, location, reserveLocation, appKey, appSecret, false);
        this.initOkHttpClient();
    }

    public DefaultApiClient(Map<String, String> serverUrlMap, String location, List<String> reserveLocation, String appKey, String appSecret, String encMethod, boolean encryptionEnable) throws ApiException {
        this.encMethod = encMethod;
        this.encryptionEnable = encryptionEnable;
        this.setServerUrl(serverUrlMap, location, reserveLocation, appKey, appSecret, false);
        this.initOkHttpClient();
    }

    public DefaultApiClient(Map<String, String> serverUrlMap, String location, List<String> reserveLocation, String appKey, String appSecret, Integer connectTimeout, Integer readTimeout, Integer writeTimeout) throws ApiException {
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.connectTimeout = connectTimeout;
        this.setServerUrl(serverUrlMap, location, reserveLocation, appKey, appSecret, false);
        this.initOkHttpClient();
    }

    public DefaultApiClient(Map<String, String> serverUrlMap, String location, String appKey, String appSecret, Integer connectTimeout, Integer readTimeout, Integer writeTimeout) throws ApiException {
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.connectTimeout = connectTimeout;
        this.setServerUrl(serverUrlMap, location, this.reserveLocation, appKey, appSecret, true);
        this.initOkHttpClient();
    }

    public DefaultApiClient(String serverUrl, String appKey, String appSecret, String encMethod, Boolean encryptionEnable) {
        this.encMethod = encMethod;
        this.encryptionEnable = encryptionEnable;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
        this.initOkHttpClient();
    }

    public DefaultApiClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
        this.initOkHttpClient();
    }

    public DefaultApiClient(String serverUrl, String appKey, String appSecret, String format) {
        this(serverUrl, appKey, appSecret);
        this.format = format;
    }

    public DefaultApiClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultApiClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        this(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
        this.signMethod = signMethod;
    }

    private void initOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        ConnectionPool connectionPool = new ConnectionPool(this.maxIdleConnections, this.keepAliveDuration, TimeUnit.SECONDS);
        builder.connectionPool(connectionPool);
        builder.connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS);
        builder.readTimeout(this.readTimeout, TimeUnit.MILLISECONDS);
        builder.writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS);
        this.client = builder.build();
    }

    @Override
    public <T extends ApiResponse> T execute(ApiRequest<T> request) throws ApiException {
        T t = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank(this.serverUrl)) {
            try {
                t = this._execute(request, this.serverUrl);
                return t;
            }
            catch (ApiException e1) {
                throw new ApiException(e1.getMessage());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new ApiException("\u5730\u5740\u4e0d\u53ef\u7528\uff0c" + e2);
            }
        }
        Integer isLocation = 0;
        String locaServerUrl = null;
        try {
            if (this.locationUrlMap.size() > 0) {
                locaServerUrl = this.getServerUrlByRoundRobin(this.locationUrlMap);
                isLocation = 1;
            } else {
                this.regainLocationUrlMap();
                if (this.standbyUrlMap.size() > 0) {
                    locaServerUrl = this.getRandomServerUrl(this.standbyUrlMap);
                    isLocation = 2;
                } else {
                    this.regainStandbyUrlMap();
                    if (this.reserveUrlMap.size() > 0) {
                        locaServerUrl = this.getRandomServerUrl(this.reserveUrlMap);
                        isLocation = 3;
                    } else {
                        this.regainReserveUrlMap();
                        locaServerUrl = this.getUsableServerUrl();
                    }
                }
            }
            String executeServerUrl = "http://" + locaServerUrl + "/rest/cip/kitty/%s/sop";
            t = this._execute(request, executeServerUrl);
        }
        catch (ApiException e1) {
            throw new ApiException(e1.getMessage());
        }
        catch (Exception e2) {
            log.warn("\u5730\u5740:" + locaServerUrl + " \u5730\u57df\u6807\u8bc6:" + this.serverUrlMap.get(locaServerUrl) + ",\u6b64\u5bc6\u7801\u4e2d\u53f0\u670d\u52a1\u5730\u5740\u4e0d\u53ef\u7528");
            if (isLocation == 1) {
                this.locationUrlMap.remove(locaServerUrl);
                this.disLocationUrlMap.put(locaServerUrl, this.serverUrlMap.get(locaServerUrl));
                this.regainLocationUrlMap();
            } else if (isLocation == 2) {
                this.standbyUrlMap.remove(locaServerUrl);
                this.disStandbyUrlMap.put(locaServerUrl, this.serverUrlMap.get(locaServerUrl));
                this.regainStandbyUrlMap();
            } else {
                this.reserveUrlMap.remove(locaServerUrl);
                this.disReserveUrlMap.put(locaServerUrl, this.serverUrlMap.get(locaServerUrl));
                this.regainReserveUrlMap();
            }
            Integer flag = 0;
            if (this.locationUrlMap.size() > 0) {
                locaServerUrl = this.getRandomServerUrl(this.locationUrlMap);
                flag = 1;
            } else if (this.standbyUrlMap.size() > 0) {
                locaServerUrl = this.getRandomServerUrl(this.standbyUrlMap);
                flag = 2;
            } else if (this.reserveUrlMap.size() > 0) {
                locaServerUrl = this.getRandomServerUrl(this.reserveUrlMap);
                flag = 3;
            } else {
                throw new ApiException("\u65e0\u6cd5\u83b7\u53d6\u5230\u53ef\u7528\u5730\u5740");
            }
            Boolean check2 = this.healthCheck(locaServerUrl, Boolean.FALSE);
            if (check2.booleanValue()) {
                log.warn("\u672c\u6b21\u8bf7\u6c42\u4f7f\u7528\u5730\u5740\u5207\u6362\u4e3a: \u5730\u5740:" + locaServerUrl + " \u5730\u57df\u6807\u8bc6:" + this.serverUrlMap.get(locaServerUrl));
                try {
                    String executeServerUrl = "http://" + locaServerUrl + "/rest/cip/kitty/%s/sop";
                    t = this._execute(request, executeServerUrl);
                }
                catch (Exception e) {
                    throw new ApiException(e.getMessage());
                }
            }
            if (flag == 1) {
                this.locationUrlMap.remove(locaServerUrl);
                this.disLocationUrlMap.put(locaServerUrl, this.serverUrlMap.get(locaServerUrl));
                this.regainLocationUrlMap();
            } else if (flag == 2) {
                this.standbyUrlMap.remove(locaServerUrl);
                this.disStandbyUrlMap.put(locaServerUrl, this.serverUrlMap.get(locaServerUrl));
                this.regainStandbyUrlMap();
            } else {
                this.reserveUrlMap.remove(locaServerUrl);
                this.disReserveUrlMap.put(locaServerUrl, this.serverUrlMap.get(locaServerUrl));
                this.regainReserveUrlMap();
            }
            throw new ApiException("\u672c\u6b21\u8bf7\u6c42\u65e0\u6cd5\u83b7\u53d6\u5230\u53ef\u7528\u5730\u5740");
        }
        return t;
    }

    @Override
    public Map<String, String> getLocalUrlMap() {
        Map<String, String> localUrlMap = this.locationUrlMap.size() > 0 ? this.locationUrlMap : (this.standbyUrlMap.size() > 0 ? this.standbyUrlMap : this.reserveUrlMap);
        return localUrlMap;
    }

    private <T extends ApiResponse> T _execute(ApiRequest<T> request, String serverUrl) throws ApiException, IOException {
        log.info("\u5f53\u524d\u4e2d\u53f0\u6267\u884c\u7684\u5730\u5740\u4e3a:" + serverUrl);
        long start = System.currentTimeMillis();
        ApiParser<T> parser = null;
        if (this.needEnableParser) {
            parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass(), this.useSimplifyJson);
        }
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                ApiResponse localResponse = null;
                try {
                    localResponse = (ApiResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException("\u7cfb\u7edf\u5f02\u5e38\uff1a" + xe.getMessage(), xe);
                }
                localResponse.setErrorCode(e.getErrCode());
                localResponse.setMsg(e.getErrMsg());
                return (T)localResponse;
            }
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        ApiHashMap appParams = new ApiHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        ApiHashMap protocalMustParams = new ApiHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("version", "1");
        protocalMustParams.put("appKey", this.appKey);
        protocalMustParams.put("encMethod", this.encMethod);
        protocalMustParams.put("encryptionEnable", String.valueOf(this.encryptionEnable));
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)timestamp);
        protocalMustParams.put("nonce", RandomStringUtils.randomAlphanumeric(10));
        request.getHeaderMap().put("x-request-id", RandomStringUtils.randomAlphanumeric(10));
        requestHolder.setProtocalMustParams(protocalMustParams);
        ApiHashMap protocalOptParams = new ApiHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("signMethod", this.signMethod);
        protocalOptParams.put("signVersion", "1.0");
        if (this.useSimplifyJson) {
            protocalOptParams.put("simplify", Boolean.TRUE.toString());
        }
        requestHolder.setProtocalOptParams(protocalOptParams);
        try {
            if (this.encryptionEnable) {
                ApiHashMap newApplicationParams = requestHolder.getApplicationParams();
                newApplicationParams.forEach((key, value) -> {
                    block4: {
                        try {
                            if ("AES".equals(this.encMethod)) {
                                newApplicationParams.put((String)key, AesUtils.encrypt(value, AesUtils.generateKey(this.appSecret)));
                                break block4;
                            }
                            if ("SM4".equals(this.encMethod)) {
                                newApplicationParams.put((String)key, SM4Utils.encrypt(value, AesUtils.generateKey(this.appSecret)));
                                break block4;
                            }
                            throw new ApiException("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7c7b\u578b");
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                requestHolder.setApplicationParams(newApplicationParams);
            }
            protocalMustParams.put("sign", ApiUtils.signTopRequest(requestHolder, this.appSecret, this.signMethod));
            String realServerUrl = this.getServerUrl(serverUrl, request.getApiMethodName(), request.getApiModel());
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            String fullUrl = WebUtils.buildRequestUrl(realServerUrl, sysMustQuery, sysOptQuery);
            String rsp = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            if (request instanceof ApiUploadRequest) {
                throw new ApiException("\u5f53\u4e14\u7248\u672c\u5ba2\u6237\u7aef\u6682\u4e0d\u652f\u6301\u6587\u4ef6\u4e0a\u4f20.");
            }
            rsp = "GET".equalsIgnoreCase(request.getExecuteMethod()) ? WebUtils.doGet(this.client, fullUrl, appParams, "UTF-8", request.getHeaderMap()) : WebUtils.doPost(this.client, fullUrl, appParams, request.getHeaderMap(), null, null);
            requestHolder.setResponseBody(rsp);
        }
        catch (IOException e) {
            ApiLogger.logApiError(this.appKey, request.getApiMethodName(), serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new IOException(e.getMessage());
        }
        ApiResponse tRsp = null;
        if (this.needEnableParser) {
            Object data;
            JSONObject jsonObject;
            String responseBody = requestHolder.getResponseBody();
            if (this.encryptionEnable && (jsonObject = JSON.parseObject(responseBody)).containsKey("data") && null != (data = jsonObject.get("data"))) {
                String dataStr = JSON.toJSONString(data);
                JSONObject dataObject = JSON.parseObject(dataStr);
                dataObject.forEach((key, value) -> {
                    try {
                        if ("AES".equals(this.encMethod)) {
                            dataObject.put((String)key, (Object)AesUtils.decrypt(value.toString(), AesUtils.generateKey(this.appSecret)));
                        } else {
                            dataObject.put((String)key, (Object)SM4Utils.decrypt(value.toString(), AesUtils.generateKey(this.appSecret)));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                jsonObject.put("data", (Object)dataObject);
                responseBody = JSON.toJSONString(jsonObject);
            }
            tRsp = (ApiResponse)parser.parse(responseBody);
            tRsp.setBody(responseBody);
        } else {
            try {
                tRsp = (ApiResponse)request.getResponseClass().newInstance();
                tRsp.setBody(requestHolder.getResponseBody());
            }
            catch (Exception e) {
                throw new ApiException("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage(), e);
            }
        }
        tRsp.setParams(appParams);
        if (!tRsp.isSuccess()) {
            ApiLogger.logApiError(this.appKey, request.getApiMethodName(), serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, tRsp.getBody());
        }
        return (T)tRsp;
    }

    public String getServerUrl(String serverUrl, String apiName, String apiModel) {
        String normLink = apiName.replace(".", "-");
        if (!StringUtils.isEmpty(serverUrl) && serverUrl.contains("%s")) {
            return String.format(serverUrl, apiModel) + "/" + normLink;
        }
        if (StringUtils.isEmpty(apiModel)) {
            return serverUrl + "/" + normLink;
        }
        return serverUrl + "/" + apiModel + "/" + normLink;
    }

    public void setServerUrl(Map<String, String> serverUrlMap, String location, List<String> reserveLocation, String appKey, String appSecret, Boolean isOnlyLocation) throws ApiException {
        if (serverUrlMap.size() == 0) {
            throw new ApiException("\u65e0\u6cd5\u83b7\u53d6\u5230\u53ef\u7528\u5730\u5740");
        }
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.location = location;
        this.reserveLocation = reserveLocation;
        this.getServerUrlMap(serverUrlMap, isOnlyLocation);
        this.setLocationUrlMap(isOnlyLocation);
        this.serverUrlMapHealthCheck();
        this.regainLocationUrlMap();
        this.regainStandbyUrlMap();
        this.regainReserveUrlMap();
    }

    public String getRandomServerUrl(Map<String, String> serverUrlMap) {
        Set<String> serverUrlSet = serverUrlMap.keySet();
        ArrayList<String> serverUrlList = new ArrayList<String>(serverUrlSet);
        Random random = new Random();
        int pos = random.nextInt(serverUrlList.size());
        String serverUrl = (String)serverUrlList.get(pos);
        return serverUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerUrlByRoundRobin(Map<String, String> serverUrlMap) {
        Set<String> serverUrlSet = serverUrlMap.keySet();
        ArrayList<String> serverUrlList = new ArrayList<String>(serverUrlSet);
        DefaultApiClient defaultApiClient = this;
        synchronized (defaultApiClient) {
            String serverUrl = (String)serverUrlList.get(this.pos);
            this.pos = (this.pos + 1) % serverUrlList.size();
            return serverUrl;
        }
    }

    public Boolean healthCheck(String serverUrl, Boolean isServer) {
        StringBuffer result;
        HttpURLConnection connection;
        block10: {
            connection = null;
            InputStream is = null;
            BufferedReader br = null;
            result = new StringBuffer();
            try {
                URL url = new URL("http://" + serverUrl + "/actuator/health");
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setReadTimeout(this.readTimeout);
                connection.setConnectTimeout(this.connectTimeout);
                connection.connect();
                if (connection.getResponseCode() == 200) {
                    is = connection.getInputStream();
                    if (null != is) {
                        br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        String temp = null;
                        while (null != (temp = br.readLine())) {
                            result.append(temp);
                        }
                    }
                    break block10;
                }
                return Boolean.FALSE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        connection.disconnect();
        JSONObject jsonObject = JSONObject.parseObject(result.toString());
        if (null != jsonObject) {
            String status = (String)jsonObject.get("status");
            if (org.apache.commons.lang3.StringUtils.equals("DOWN", status)) {
                return Boolean.FALSE;
            }
            if (org.apache.commons.lang3.StringUtils.equals("UP", status)) {
                if (isServer.booleanValue()) {
                    JSONObject server = jsonObject.getJSONObject("components").getJSONObject("http").getJSONObject("details").getJSONObject("server");
                    Map<String, Object> innerMap = server.getInnerMap();
                    Set<String> serverUrlSet = innerMap.keySet();
                    for (String url : serverUrlSet) {
                        this.serverUrlMap.put(url, innerMap.get(url).toString());
                    }
                }
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public void getServerUrlMap(Map<String, String> serverUrlMap, Boolean isOnlyLocation) throws ApiException {
        if (null == serverUrlMap || serverUrlMap.size() == 0) {
            throw new ApiException("\u4f20\u5165\u7684\u670d\u52a1\u5730\u5740\u96c6\u5408\u4e3a\u7a7a");
        }
        Set<String> urlSet = serverUrlMap.keySet();
        for (String url : urlSet) {
            Boolean check2;
            String serverLocation;
            if (isOnlyLocation.booleanValue() && !org.apache.commons.lang3.StringUtils.equals(serverLocation = serverUrlMap.get(url), this.location) || !(check2 = this.healthCheck(url, Boolean.TRUE)).booleanValue()) continue;
            break;
        }
        if (this.serverUrlMap.size() == 0) {
            throw new ApiException("\u65e0\u6cd5\u83b7\u53d6\u5230\u53ef\u7528\u5730\u5740");
        }
    }

    public void serverUrlMapHealthCheck() throws ApiException {
        HashSet<String> locationUrlSet = new HashSet<String>();
        locationUrlSet.addAll(this.locationUrlMap.keySet());
        for (String string : locationUrlSet) {
            Boolean check2 = this.healthCheck(string, Boolean.FALSE);
            if (check2.booleanValue()) continue;
            this.disLocationUrlMap.put(string, this.locationUrlMap.get(string));
            this.locationUrlMap.remove(string);
        }
        HashSet<String> standbyUrlSet = new HashSet<String>();
        standbyUrlSet.addAll(this.standbyUrlMap.keySet());
        for (String standbyUrl : standbyUrlSet) {
            Boolean check3 = this.healthCheck(standbyUrl, Boolean.FALSE);
            if (check3.booleanValue()) continue;
            this.disStandbyUrlMap.put(standbyUrl, this.standbyUrlMap.get(standbyUrl));
            this.standbyUrlMap.remove(standbyUrl);
        }
        if (this.standbyUrlMap.size() == 0 && this.locationUrlMap.size() == 0) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(this.reserveUrlMap.keySet());
            for (String reserveUrl : hashSet) {
                Boolean check4 = this.healthCheck(reserveUrl, Boolean.FALSE);
                if (check4.booleanValue()) continue;
                this.disReserveUrlMap.put(reserveUrl, this.reserveUrlMap.get(reserveUrl));
                this.reserveUrlMap.remove(reserveUrl);
            }
        }
        if (this.standbyUrlMap.size() == 0 && this.locationUrlMap.size() == 0 && this.reserveUrlMap.size() == 0) {
            throw new ApiException("\u65e0\u6cd5\u83b7\u53d6\u5230\u53ef\u7528\u5730\u5740");
        }
    }

    public void setLocationUrlMap(Boolean isOnlyLocation) {
        Set<Map.Entry<String, String>> entries = this.serverUrlMap.entrySet();
        if (isOnlyLocation.booleanValue()) {
            for (Map.Entry<String, String> entry : entries) {
                if (!org.apache.commons.lang3.StringUtils.startsWith(entry.getValue(), this.location)) continue;
                this.locationUrlMap.put(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, String> entry : entries) {
                if (org.apache.commons.lang3.StringUtils.startsWith(entry.getValue(), this.location)) {
                    this.locationUrlMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                Boolean flag = Boolean.FALSE;
                if (null != this.reserveLocation && this.reserveLocation.size() > 0) {
                    for (String reserverloc : this.reserveLocation) {
                        if (!org.apache.commons.lang3.StringUtils.startsWith(entry.getValue(), reserverloc)) continue;
                        this.reserveUrlMap.put(entry.getKey(), entry.getValue());
                        flag = Boolean.TRUE;
                        break;
                    }
                }
                if (flag.booleanValue()) continue;
                this.standbyUrlMap.put(entry.getKey(), entry.getValue());
            }
            if (this.standbyUrlMap.size() == 0) {
                this.standbyUrlMap.putAll(this.locationUrlMap);
            }
        }
    }

    public String getUsableServerUrl() throws ApiException {
        String randomServerUrl = this.getRandomServerUrl(this.serverUrlMap);
        Boolean check2 = this.healthCheck(randomServerUrl, Boolean.FALSE);
        if (check2.booleanValue()) {
            if (org.apache.commons.lang3.StringUtils.startsWith(this.serverUrlMap.get(randomServerUrl), this.location)) {
                this.locationUrlMap.put(randomServerUrl, this.serverUrlMap.get(randomServerUrl));
                this.disLocationUrlMap.remove(randomServerUrl);
            } else {
                Boolean flag = Boolean.FALSE;
                if (null != this.reserveLocation && this.reserveLocation.size() > 0) {
                    for (String reserverloc : this.reserveLocation) {
                        if (!org.apache.commons.lang3.StringUtils.startsWith(randomServerUrl, reserverloc)) continue;
                        this.reserveUrlMap.put(randomServerUrl, this.serverUrlMap.get(randomServerUrl));
                        this.disReserveUrlMap.remove(randomServerUrl);
                        flag = Boolean.TRUE;
                        break;
                    }
                }
                if (!flag.booleanValue()) {
                    this.standbyUrlMap.put(randomServerUrl, this.serverUrlMap.get(randomServerUrl));
                    this.disStandbyUrlMap.remove(randomServerUrl);
                }
            }
            return randomServerUrl;
        }
        throw new ApiException("\u65e0\u6cd5\u83b7\u53d6\u5230\u53ef\u7528\u5730\u5740");
    }

    public void regainLocationUrlMap() {
        if (this.disLocationUrlMap.size() > 0) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(60000 * DefaultApiClient.this.regainTime);
                        HashSet<String> disLocationUrlSet = new HashSet<String>();
                        disLocationUrlSet.addAll(DefaultApiClient.this.disLocationUrlMap.keySet());
                        for (String disLocationUrl : disLocationUrlSet) {
                            Boolean check2 = DefaultApiClient.this.healthCheck(disLocationUrl, Boolean.FALSE);
                            if (!check2.booleanValue()) continue;
                            DefaultApiClient.this.locationUrlMap.put(disLocationUrl, DefaultApiClient.this.disLocationUrlMap.get(disLocationUrl));
                            DefaultApiClient.this.disLocationUrlMap.remove(disLocationUrl);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    public void regainStandbyUrlMap() {
        if (this.disStandbyUrlMap.size() > 0) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(60000 * DefaultApiClient.this.regainTime);
                        HashSet<String> disStandByUrlSet = new HashSet<String>();
                        disStandByUrlSet.addAll(DefaultApiClient.this.disStandbyUrlMap.keySet());
                        for (String disStandByUrl : disStandByUrlSet) {
                            Boolean check2 = DefaultApiClient.this.healthCheck(disStandByUrl, Boolean.FALSE);
                            if (!check2.booleanValue()) continue;
                            DefaultApiClient.this.standbyUrlMap.put(disStandByUrl, DefaultApiClient.this.disStandbyUrlMap.get(disStandByUrl));
                            DefaultApiClient.this.disStandbyUrlMap.remove(disStandByUrl);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    public void regainReserveUrlMap() {
        if (this.disReserveUrlMap.size() > 0) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(60000 * DefaultApiClient.this.regainTime);
                        HashSet<String> disReserveUrlSet = new HashSet<String>();
                        disReserveUrlSet.addAll(DefaultApiClient.this.disReserveUrlMap.keySet());
                        for (String disReserveUrl : disReserveUrlSet) {
                            Boolean check2 = DefaultApiClient.this.healthCheck(disReserveUrl, Boolean.FALSE);
                            if (!check2.booleanValue()) continue;
                            DefaultApiClient.this.reserveUrlMap.put(disReserveUrl, DefaultApiClient.this.disReserveUrlMap.get(disReserveUrl));
                            DefaultApiClient.this.disReserveUrlMap.remove(disReserveUrl);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    protected String getSdkVersion() {
        return "openapi-sdk-java-20180204";
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setUseSimplifyJson(boolean useSimplifyJson) {
        this.useSimplifyJson = useSimplifyJson;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        ApiLogger.setNeedEnableLogger(needEnableLogger);
    }

    public void setIgnoreSSLCheck(boolean ignore) {
        WebUtils.setIgnoreSSLCheck(ignore);
    }

    public void setUseGzipEncoding(boolean useGzipEncoding) {
        this.useGzipEncoding = useGzipEncoding;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void resetServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getRequestUrl() {
        return this.serverUrl;
    }

    public String getAppKey() {
        return this.appKey;
    }
}

