/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.security.ec;

import java.math.BigInteger;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class ECDomainParametersHelper {
    private static ECDomainParameters ecDomainParameters = null;
    private static ECParameterSpec params = null;
    private static ECPoint ecc_point_g;
    private static ECCurve.Fp ecc_curve;
    public static final BigInteger ecc_p;
    public static final BigInteger ecc_a;
    public static final BigInteger ecc_b;
    public static final BigInteger ecc_gx;
    public static final BigInteger ecc_gy;
    public static final BigInteger ecc_n;
    private static ECDomainParameters test_ecDomainParameters;
    private static ECParameterSpec test_params;
    private static ECPoint test_ecc_point_g;
    private static ECCurve.Fp test_ecc_curve;
    public static final BigInteger test_ecc_p;
    public static final BigInteger test_ecc_a;
    public static final BigInteger test_ecc_b;
    public static final BigInteger test_ecc_gx;
    public static final BigInteger test_ecc_gy;
    public static final BigInteger test_ecc_n;

    public static ECCurve getECCurve() {
        return ecc_curve;
    }

    public static ECPoint getECPointG() {
        return ecc_point_g;
    }

    public static ECDomainParameters getECDomainParameters() {
        return ecDomainParameters;
    }

    public static ECParameterSpec getECParameterSpec() {
        return params;
    }

    public static String getSM2Algorithm() {
        return "1.2.156.10197.1.301";
    }

    public static ECCurve getECCurve(boolean isTest) {
        return isTest ? test_ecc_curve : ecc_curve;
    }

    public static ECPoint getECPointG(boolean isTest) {
        return isTest ? test_ecc_point_g : ecc_point_g;
    }

    public static ECDomainParameters getECDomainParameters(boolean isTest) {
        return isTest ? test_ecDomainParameters : ecDomainParameters;
    }

    public static ECParameterSpec getECParameterSpec(boolean isTest) {
        return isTest ? test_params : params;
    }

    static {
        ecc_p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
        ecc_a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
        ecc_b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
        ecc_gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
        ecc_gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
        ecc_n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
        test_ecDomainParameters = null;
        test_params = null;
        test_ecc_p = new BigInteger("8542D69E4C044F18E8B92435BF6FF7DE457283915C45517D722EDB8B08F1DFC3", 16);
        test_ecc_a = new BigInteger("787968B4FA32C3FD2417842E73BBFEFF2F3C848B6831D7E0EC65228B3937E498", 16);
        test_ecc_b = new BigInteger("63E4C6D3B23B0C849CF84241484BFE48F61D59A5B16BA06E6E12D1DA27C5249A", 16);
        test_ecc_gx = new BigInteger("421DEBD61B62EAB6746434EBC3CC315E32220B3BADD50BDC4C4E6C147FEDD43D", 16);
        test_ecc_gy = new BigInteger("0680512BCBB42C07D47349D2153B70C4E5D7FDFCBFA36EA1A85841B9E46E09A2", 16);
        test_ecc_n = new BigInteger("8542D69E4C044F18E8B92435BF6FF7DD297720630485628D5AE74EE7C32E79B7", 16);
        BigInteger h = BigInteger.valueOf(1L);
        ecc_curve = new ECCurve.Fp(ecc_p, ecc_a, ecc_b, null, null);
        ecc_point_g = ecc_curve.createPoint(ecc_gx, ecc_gy);
        params = new ECParameterSpec((ECCurve)ecc_curve, ecc_point_g, ecc_n, h);
        ecDomainParameters = new ECDomainParameters((ECCurve)ecc_curve, ecc_point_g, ecc_n, h);
        test_ecc_curve = new ECCurve.Fp(test_ecc_p, test_ecc_a, test_ecc_b, null, null);
        test_ecc_point_g = test_ecc_curve.createPoint(test_ecc_gx, test_ecc_gy);
        test_params = new ECParameterSpec((ECCurve)test_ecc_curve, test_ecc_point_g, test_ecc_n, h);
        test_ecDomainParameters = new ECDomainParameters((ECCurve)test_ecc_curve, test_ecc_point_g, test_ecc_n, h);
    }
}

