/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.security;

import cn.unitid.easypki.security.SM2BCKeyPair;
import cn.unitid.easypki.security.ec.ECDomainParametersHelper;
import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;

public class SM2BCKeyPairGenerator {
    public static AsymmetricCipherKeyPair generateAsymmetricCipherKeyPair() {
        ECDomainParameters ecDomainParameters = ECDomainParametersHelper.getECDomainParameters();
        ECKeyGenerationParameters kenGenParam = new ECKeyGenerationParameters(ecDomainParameters, new SecureRandom());
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)kenGenParam);
        return keyPairGenerator.generateKeyPair();
    }

    public static SM2BCKeyPair generateKeyPair() throws IOException {
        AsymmetricCipherKeyPair keyPair = SM2BCKeyPairGenerator.generateAsymmetricCipherKeyPair();
        return new SM2BCKeyPair(keyPair);
    }
}

