/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.security;

import cn.unitid.easypki.security.ec.ECDomainParametersHelper;
import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM2BCKeyPair {
    private BCECPublicKey ecPublicKey;
    private BCECPrivateKey ecPrivateKey;

    public SM2BCKeyPair(AsymmetricCipherKeyPair keyPair) throws IOException {
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic();
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
        this.ecPublicKey = new BCECPublicKey("1.2.156.10197.1.301", publicKeyParameters, ECDomainParametersHelper.getECParameterSpec(), BouncyCastleProvider.CONFIGURATION);
        this.ecPrivateKey = new BCECPrivateKey("1.2.156.10197.1.301", privateKeyParameters, this.ecPublicKey, ECDomainParametersHelper.getECParameterSpec(), BouncyCastleProvider.CONFIGURATION);
    }

    public SM2BCKeyPair(BCECPublicKey publicKey, BCECPrivateKey privateKey) throws IOException {
        this.ecPublicKey = publicKey;
        this.ecPrivateKey = privateKey;
    }

    public BCECPublicKey getBCECPublicKey() {
        return this.ecPublicKey;
    }

    public BCECPrivateKey getBCECPrivateKey() {
        return this.ecPrivateKey;
    }
}

