/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.provider.asymmetric.sm2;

import cn.unitid.easypki.provider.identifier.EPAlgorithmIdentifier;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2BCPublicKey
implements ECPublicKey {
    private ECPoint ecPointQ = null;
    private boolean withCompression = false;
    private static ECParameterSpec params = null;
    private static ECCurve.Fp ecc_curve;

    public SM2BCPublicKey(ECPoint ecPoint) {
        this.ecPointQ = ecPoint;
    }

    public SM2BCPublicKey(BCECPublicKey publicKey) {
        this.ecPointQ = publicKey.getQ();
    }

    public static SM2BCPublicKey getInstance(SubjectPublicKeyInfo subjectPublicKeyInfo) throws InvalidKeyException {
        byte[] publicKey = subjectPublicKeyInfo.getPublicKeyData().getOctets();
        return new SM2BCPublicKey(publicKey);
    }

    public SM2BCPublicKey(byte[] publicKey) throws InvalidKeyException {
        byte[] keyBytes = null;
        if (publicKey[0] == 0) {
            keyBytes = new byte[publicKey.length - 1];
            System.arraycopy(publicKey, 1, keyBytes, 0, publicKey.length - 1);
        } else {
            keyBytes = publicKey;
        }
        int length = keyBytes.length;
        if (length == 65 || length == 66) {
            this.withCompression = false;
            byte[] X = new byte[32];
            byte[] Y = new byte[32];
            if (length == 65) {
                System.arraycopy(keyBytes, 1, X, 0, 32);
                System.arraycopy(keyBytes, 33, Y, 0, 32);
            } else {
                System.arraycopy(keyBytes, 1, X, 0, 32);
                System.arraycopy(keyBytes, length - 32, Y, 0, 32);
            }
            BigInteger bigX = new BigInteger(1, X);
            BigInteger bigY = new BigInteger(1, Y);
            this.ecPointQ = ecc_curve.createPoint(bigX, bigY);
        } else if (keyBytes.length == 33) {
            this.withCompression = true;
            this.ecPointQ = ecc_curve.decodePoint(keyBytes);
        } else if (keyBytes.length == 32) {
            this.withCompression = true;
            byte[] X = new byte[33];
            X[0] = 2;
            System.arraycopy(keyBytes, 0, X, 1, 32);
            this.ecPointQ = ecc_curve.decodePoint(X);
        } else {
            throw new InvalidKeyException();
        }
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public byte[] getEncoded() {
        if (this.withCompression) {
            int PC = this.ecPointQ.getAffineYCoord().toBigInteger().testBit(0) ? 3 : 2;
            byte[] X = this.ecPointQ.getAffineXCoord().toBigInteger().toByteArray();
            byte[] PO = new byte[X.length + 1];
            PO[0] = PC;
            System.arraycopy(X, 0, PO, 1, X.length);
            return PO;
        }
        byte[] X = this.getExactBigIntegerBytes(this.ecPointQ.getAffineXCoord().toBigInteger());
        byte[] Y = this.getExactBigIntegerBytes(this.ecPointQ.getAffineYCoord().toBigInteger());
        X = this.convertTo32Bytes(X);
        Y = this.convertTo32Bytes(Y);
        byte[] PO = new byte[X.length + Y.length + 1];
        PO[0] = 4;
        System.arraycopy(X, 0, PO, 1, X.length);
        System.arraycopy(Y, 0, PO, X.length + 1, Y.length);
        return PO;
    }

    private byte[] convertTo32Bytes(byte[] xData) {
        byte[] data = new byte[32];
        if (xData.length == 31) {
            System.arraycopy(xData, 0, data, 1, xData.length);
        } else if (xData.length == 33) {
            System.arraycopy(xData, 1, data, 0, 32);
        } else {
            data = xData;
        }
        return data;
    }

    private byte[] getExactBigIntegerBytes(BigInteger big) {
        byte[] vValue = big.toByteArray();
        byte[] rValue = null;
        if (-1 == big.signum() && vValue.length == 31) {
            rValue = new byte[vValue.length + 1];
            rValue[0] = -1;
            System.arraycopy(vValue, 0, rValue, 1, vValue.length);
        } else {
            rValue = vValue;
        }
        return rValue;
    }

    public String getFormat() {
        return "X.509";
    }

    public ECParameterSpec getParams() {
        return params;
    }

    public ECPoint getQ() {
        return this.ecPointQ;
    }

    public ECParameterSpec getParameters() {
        return params;
    }

    public static ECCurve getECCurve() {
        return ecc_curve;
    }

    public SubjectPublicKeyInfo toSubjectPublicKeyInfo() {
        byte[] keyData = this.getEncoded();
        AlgorithmIdentifier algId = EPAlgorithmIdentifier.SM2_PUBLIC_KEY_ALGORITHM;
        return new SubjectPublicKeyInfo(algId, keyData);
    }

    static {
        BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
        BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
        BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
        BigInteger Gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
        BigInteger Gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
        BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
        BigInteger h = BigInteger.valueOf(1L);
        ecc_curve = new ECCurve.Fp(p, a, b, null, null);
        ECPoint ecc_point_g = ecc_curve.createPoint(Gx, Gy);
        params = new ECParameterSpec((ECCurve)ecc_curve, ecc_point_g, n, h);
    }
}

