/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7.envelope;

import cn.unitid.easypki.crypto.SM2AsymmetricCipher;
import cn.unitid.easypki.crypto.SM4SymmetricCipher;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientOperator;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipient;
import org.bouncycastle.jcajce.io.CipherInputStream;
import org.bouncycastle.operator.InputDecryptor;

public class EPKeyTransEnvelopedRecipient
extends JceKeyTransRecipient {
    private PrivateKey privateKey;
    private InputDecryptor inputDecryptor = null;

    public EPKeyTransEnvelopedRecipient(PrivateKey recipientKey) {
        super(recipientKey);
        this.privateKey = recipientKey;
    }

    public EPKeyTransEnvelopedRecipient(InputDecryptor inputDecryptor) {
        super(null);
        this.privateKey = null;
        this.inputDecryptor = inputDecryptor;
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        RecipientOperator recipientOperator = null;
        final Key secretKey = "1.2.156.10197.1.301.3".equals(keyEncryptionAlgorithm.getAlgorithm().getId()) ? this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey) : super.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        String getAlgorithm = secretKey.getAlgorithm();
        if (getAlgorithm.startsWith("SM4") || getAlgorithm.startsWith("1.2.156.10197.1.104")) {
            recipientOperator = new RecipientOperator(new InputDecryptor(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return contentEncryptionAlgorithm;
                }

                public InputStream getInputStream(InputStream dataIn) {
                    return this.doDecrypt(dataIn);
                }

                private InputStream doDecrypt(InputStream dataIn) {
                    try {
                        DEROctetString iv = (DEROctetString)contentEncryptionAlgorithm.getParameters();
                        SM4SymmetricCipher sm4Cipher = new SM4SymmetricCipher("CBC");
                        sm4Cipher.init(2, secretKey.getEncoded(), iv.getOctets());
                        byte[] data = IOUtils.toByteArray((InputStream)dataIn);
                        sm4Cipher.update(data);
                        byte[] plainData = sm4Cipher.doFinal();
                        return new ByteArrayInputStream(plainData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
        } else {
            final Cipher dataCipher = this.contentHelper.createContentCipher(secretKey, contentEncryptionAlgorithm);
            recipientOperator = new RecipientOperator(new InputDecryptor(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return contentEncryptionAlgorithm;
                }

                public InputStream getInputStream(InputStream dataIn) {
                    return new CipherInputStream(dataIn, dataCipher);
                }
            });
        }
        return recipientOperator;
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedEncryptionKey) throws CMSException {
        SecretKeySpec secretKey = null;
        try {
            if (this.privateKey != null) {
                SM2AsymmetricCipher sm2Cipher = new SM2AsymmetricCipher();
                sm2Cipher.init(2, this.privateKey);
                sm2Cipher.update(encryptedEncryptionKey);
                byte[] encryptionKey = sm2Cipher.doFinal();
                secretKey = new SecretKeySpec(encryptionKey, "SM4");
            } else {
                InputStream cipherStream = new ByteArrayInputStream(encryptedEncryptionKey);
                cipherStream = this.inputDecryptor.getInputStream(cipherStream);
                secretKey = new SecretKeySpec(IOUtils.toByteArray((InputStream)cipherStream), "SM4");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
        return secretKey;
    }
}

