/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7.envelope;

import cn.unitid.easypki.crypto.SM4SymmetricCipher;
import cn.unitid.easypki.pkcs7.envelope.SM4CipherOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputEncryptor;

public class EPCMSContentEncryptorBuilder {
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private SecureRandom random;

    public EPCMSContentEncryptorBuilder(ASN1ObjectIdentifier var1, int var2, SecureRandom var3) {
        this.encryptionOID = var1;
        this.keySize = var2;
        this.random = var3;
    }

    public EPCMSContentEncryptorBuilder(ASN1ObjectIdentifier var1, int var2) {
        this.encryptionOID = var1;
        this.keySize = var2;
        this.random = new SecureRandom();
    }

    public EPCMSContentEncryptorBuilder setSecureRandom(SecureRandom var1) {
        this.random = var1;
        return this;
    }

    public OutputEncryptor build() throws CMSException {
        return new SM4CMSOutputEncryptor(this.encryptionOID, this.keySize, this.random);
    }

    private class SM4CMSOutputEncryptor
    implements OutputEncryptor {
        private KeyParameter encKey;
        private AlgorithmIdentifier algorithmIdentifier;
        protected SM4SymmetricCipher sm4SymmetricCipher = new SM4SymmetricCipher("CBC");

        SM4CMSOutputEncryptor(ASN1ObjectIdentifier var2, int var3, SecureRandom var5) {
            if (var5 == null) {
                var5 = new SecureRandom();
            }
            if (var3 != 16 || !var2.getId().equals(GMObjectIdentifiers.sms4_cbc.getId())) {
                throw new IllegalArgumentException("incorrect keySize for encryptionOID passed to builder.");
            }
            byte[] key = new byte[16];
            var5.nextBytes(key);
            byte[] key_iv = new byte[16];
            var5.nextBytes(key_iv);
            try {
                this.sm4SymmetricCipher.init(1, key, key_iv);
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
            this.encKey = new KeyParameter(key);
            DEROctetString asn1Encodable = new DEROctetString(key_iv);
            this.algorithmIdentifier = new AlgorithmIdentifier(var2, (ASN1Encodable)asn1Encodable);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        public OutputStream getOutputStream(OutputStream var1) {
            return new SM4CipherOutputStream(var1, this.sm4SymmetricCipher);
        }

        public GenericKey getKey() {
            return new GenericKey(this.algorithmIdentifier, this.encKey.getKey());
        }
    }
}

