/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7;

import cn.unitid.easypki.cms.SignerInformation;
import cn.unitid.easypki.pkcs7.AuthenticatedAttributesBuilder;
import cn.unitid.easypki.pkcs7.EPSignatureException;
import cn.unitid.easypki.util.CertificateConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;

public class RSAP7Signature {
    private X509Certificate signCert;
    private PrivateKey privateKey;
    private byte[] tobeSignedData;
    private List<X509Certificate> certChain = new ArrayList<X509Certificate>();

    public void initSign(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void addSigner(X509Certificate signCert) throws CertificateException {
        if (signCert != null) {
            this.signCert = signCert;
            if (!"RSA".equals(signCert.getPublicKey().getAlgorithm())) {
                throw new CertificateException("\u4ec5\u652f\u6301RSA\u7b97\u6cd5\u516c\u94a5\u8bc1\u4e66\uff01");
            }
            this.certChain.add(this.signCert);
        }
    }

    public void addCertificates(List<X509Certificate> certList) {
        if (null != certList) {
            this.certChain.addAll(certList);
        }
    }

    public void update(byte[] data) {
        this.tobeSignedData = data;
    }

    public byte[] sign() throws EPSignatureException {
        return this.sign(true);
    }

    public byte[] sign(boolean attach) throws EPSignatureException {
        if (this.signCert == null || this.privateKey == null) {
            throw new NullPointerException("signer cert or private key is null");
        }
        byte[] signedData = null;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            CMSSignedDataStreamGenerator sdGen = new CMSSignedDataStreamGenerator();
            JcaCertStore certificates = new JcaCertStore(this.certChain);
            sdGen.addCertificates((Store)certificates);
            String signatureAlgorithm = "SHA1withRSA";
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).build(this.privateKey);
            sdGen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(signer, this.signCert));
            OutputStream sigOut = sdGen.open((OutputStream)bOut, attach);
            sigOut.write(this.tobeSignedData);
            sigOut.flush();
            sigOut.close();
            signedData = bOut.toByteArray();
        }
        catch (Exception e) {
            throw new EPSignatureException("sign pkcs7 failed. cause: " + e.getMessage(), e);
        }
        return signedData;
    }

    public CMSSignedData pkcs7Sign() throws SignatureException, CertificateEncodingException {
        SignerInfo signerInfo = this.buildSignerInfo();
        return this.buildCMSSignedData(signerInfo, true);
    }

    public CMSSignedData pkcs7Sign(boolean attach) throws EPSignatureException {
        CMSSignedData cmsSignedData;
        try {
            cmsSignedData = new CMSSignedData(this.sign(attach));
        }
        catch (CMSException e) {
            throw new EPSignatureException(e.getMessage(), e);
        }
        return cmsSignedData;
    }

    public CMSSignedData pkcs7Sign(ContentSigner contentSigner, boolean attach) throws SignatureException, CertificateEncodingException {
        SignerInfo signerInfo = null;
        OutputStream outputStream = null;
        ASN1OutputStream derOutputStream = null;
        try {
            SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(new JcaX509CertificateHolder(this.signCert).toASN1Structure()));
            AlgorithmIdentifier digAlgorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.26"), (ASN1Encodable)DERNull.INSTANCE);
            DERSet authenticatedAttributes = new DERSet(AuthenticatedAttributesBuilder.buildAuthenticatedAttributes(this.tobeSignedData, digAlgorithm));
            AlgorithmIdentifier digEncryptionAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE);
            outputStream = contentSigner.getOutputStream();
            derOutputStream = ASN1OutputStream.create((OutputStream)outputStream);
            derOutputStream.writeObject((ASN1Primitive)authenticatedAttributes);
            byte[] signature = contentSigner.getSignature();
            DEROctetString encryptedDigest = new DEROctetString(signature);
            ASN1Set unauthenticatedAttributes = null;
            signerInfo = new SignerInfo(sid, digAlgorithm, (ASN1Set)authenticatedAttributes, digEncryptionAlgorithm, (ASN1OctetString)encryptedDigest, unauthenticatedAttributes);
        }
        catch (Exception e) {
            throw new SignatureException("failed to build signer info", e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (derOutputStream != null) {
                    derOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.buildCMSSignedData(signerInfo, attach);
    }

    public CMSSignedData buildCMSSignedData(SignerInfo signerInfo) throws SignatureException, CertificateEncodingException {
        return this.buildCMSSignedData(signerInfo, true);
    }

    public CMSSignedData buildCMSSignedData(SignerInfo signerInfo, boolean attach) throws SignatureException, CertificateEncodingException {
        return this.buildCMSSignedData(attach ? this.tobeSignedData : null, signerInfo, this.certChain);
    }

    public CMSSignedData buildCMSSignedData(byte[] data, SignerInfo signerInfo, List<X509Certificate> certList) throws SignatureException, CertificateEncodingException {
        CMSSignedData cmsSignedData = null;
        ASN1EncodableVector digestAlgos = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        BEROctetString octs = data == null ? null : new BEROctetString(data);
        ContentInfo encInfo = new ContentInfo(CMSObjectIdentifiers.data, (ASN1Encodable)octs);
        digestAlgos.add((ASN1Encodable)signerInfo.getDigestAlgorithm());
        signerInfos.add((ASN1Encodable)signerInfo);
        BERSet certificates = null;
        ASN1Set certCRLs = null;
        if (certList.size() != 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            try {
                Iterator<X509Certificate> it = certList.iterator();
                while (it.hasNext()) {
                    v.add((ASN1Encodable)ASN1Sequence.fromByteArray((byte[])it.next().getEncoded()));
                }
                certificates = new BERSet(v);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SignedData sd = new SignedData((ASN1Set)new DERSet(digestAlgos), encInfo, certificates, certCRLs, (ASN1Set)new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)sd);
        try {
            CMSProcessableByteArray content = new CMSProcessableByteArray(data);
            cmsSignedData = new CMSSignedData((CMSProcessable)content, contentInfo);
        }
        catch (CMSException e) {
            throw new SignatureException("pkcs7 sign failed", e);
        }
        return cmsSignedData;
    }

    private SignerInfo buildSignerInfo() throws SignatureException {
        SignerInfo signerInfo = null;
        try {
            SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(new JcaX509CertificateHolder(this.signCert).toASN1Structure()));
            AlgorithmIdentifier digAlgorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.26"), (ASN1Encodable)DERNull.INSTANCE);
            DERSet authenticatedAttributes = new DERSet(AuthenticatedAttributesBuilder.buildAuthenticatedAttributes(this.tobeSignedData, digAlgorithm));
            AlgorithmIdentifier digEncryptionAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE);
            byte[] signature = null;
            Signature sig = Signature.getInstance("SHA1WITHRSA");
            sig.initSign(this.privateKey);
            sig.update(this.tobeSignedData);
            signature = sig.sign();
            DEROctetString encryptedDigest = new DEROctetString(signature);
            ASN1Set unauthenticatedAttributes = null;
            signerInfo = new SignerInfo(sid, digAlgorithm, (ASN1Set)authenticatedAttributes, digEncryptionAlgorithm, (ASN1OctetString)encryptedDigest, unauthenticatedAttributes);
        }
        catch (Exception e) {
            throw new SignatureException("failed to build signer info", e);
        }
        return signerInfo;
    }

    public boolean verify(String pkcs7Data) throws SignatureException {
        return this.verify(pkcs7Data, true);
    }

    public boolean verify(String pkcs7Data, boolean attach) throws SignatureException {
        boolean verResult;
        ByteArrayOutputStream byteStream = null;
        try {
            byteStream = new ByteArrayOutputStream();
            if (!attach && this.tobeSignedData == null) {
                throw new SignatureException("\u975eAttach\u6a21\u5f0f\u4e0b,\u5fc5\u987b\u5148update\u5f85\u9a8c\u8bc1\u6570\u636e");
            }
            CMSSignedData sd = new CMSSignedData(Base64.decode((String)pkcs7Data));
            String contentTypeOID = sd.getSignedContentTypeOID();
            CMSSignedData signedData = null;
            if (!contentTypeOID.equals(CMSObjectIdentifiers.data.getId())) {
                throw new EPSignatureException("\u4e0d\u652f\u6301SM2 Q7\u7b7e\u540d\u9a8c\u8bc1\uff01");
            }
            signedData = attach ? new CMSSignedData(Base64.decode((String)pkcs7Data)) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(PKCSObjectIdentifiers.data, this.tobeSignedData), Base64.decode((String)pkcs7Data));
            CMSTypedData signedContent = signedData.getSignedContent();
            if (attach) {
                if (signedContent == null) {
                    throw new IOException("PKCS7\u7b7e\u540d\u4e2d\u6ca1\u6709\u5305\u542b\u7b7e\u540d\u6570\u636e");
                }
                signedContent.write((OutputStream)byteStream);
                this.tobeSignedData = byteStream.toByteArray();
            }
            Store certStore = signedData.getCertificates();
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection collection = signers.getSigners();
            Iterator iterator = collection.iterator();
            int verified = 0;
            while (iterator.hasNext()) {
                SignerInformation signer = SignerInformation.getInstance((org.bouncycastle.cms.SignerInformation)iterator.next(), (CMSProcessable)signedContent);
                Collection certCollection = certStore.getMatches((Selector)signer.getSID());
                Iterator it = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)it.next();
                if (!contentTypeOID.equals(CMSObjectIdentifiers.data.getId())) continue;
                this.signCert = CertificateConverter.fromBinary(cert.getEncoded());
                byte[] signature = signer.getSignature();
                AttributeTable signedAttributes = signer.getSignedAttributes();
                byte[] signedAttributesContent = null;
                if (signedAttributes != null) {
                    signedAttributesContent = signer.getEncodedSignedAttributes();
                    Attribute messageDigestAttr = signedAttributes.get(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
                    DEROctetString messageDigestOct = (DEROctetString)messageDigestAttr.getAttrValues().getObjectAt(0);
                    byte[] messageDigest = messageDigestOct.getOctets();
                    byte[] calculatedMessageDigest = null;
                    String digestHashAlgorithm = signer.getDigestAlgorithmID().getAlgorithm().getId();
                    if (!"1.3.14.3.2.26".equals(digestHashAlgorithm) && !"2.16.840.1.101.3.4.2.1".equals(digestHashAlgorithm)) {
                        throw new SignatureException("unsupported digest algorithm:" + signer.getDigestAlgorithmID().getAlgorithm().getId() + " in RSA P7");
                    }
                    calculatedMessageDigest = AuthenticatedAttributesBuilder.makeDigest((byte[])signedContent.getContent(), signer.getDigestAlgorithmID().getAlgorithm().getId());
                    if (!Arrays.equals(messageDigest, calculatedMessageDigest)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    signedAttributesContent = this.tobeSignedData;
                }
                String signatureAlgorithm = this.getRSASignatureAlgorithm(signer.getDigestAlgOID());
                if (!this.innerRSAVerify(signature, signedAttributesContent, this.signCert)) continue;
                ++verified;
            }
            verResult = verified == collection.size();
        }
        catch (Exception e) {
            throw new SignatureException("\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5f02\u5e38. cause: " + e.getMessage(), e);
        }
        finally {
            try {
                if (byteStream != null) {
                    byteStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return verResult;
    }

    private String getRSASignatureAlgorithm(String digestAlgorithm) {
        String algorithm = null;
        algorithm = "2.16.840.1.101.3.4.2.1".equals(digestAlgorithm) ? "SHA256withRSA" : ("1.3.14.3.2.26".equals(digestAlgorithm) ? "SHA1withRSA" : digestAlgorithm);
        return algorithm;
    }

    private boolean innerSignatureVerify(byte[] rsaSignature, byte[] data, X509Certificate x509Certificate, String signatureAlgorithm) throws EPSignatureException {
        boolean result = false;
        try {
            Signature signature = Signature.getInstance(signatureAlgorithm);
            signature.initVerify(x509Certificate);
            signature.update(data);
            result = signature.verify(rsaSignature);
        }
        catch (Exception e) {
            throw new EPSignatureException("Inner RSA Signature verify failed. cause:" + e.getMessage());
        }
        return result;
    }

    private boolean innerRSAVerify(byte[] rsaSignature, byte[] data, X509Certificate x509Certificate) throws EPSignatureException {
        try {
            byte[] rawDigest = null;
            byte[] derivedDigest = null;
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, x509Certificate);
            byte[] signature = cipher.doFinal(rsaSignature);
            switch (signature.length) {
                case 35: 
                case 51: {
                    ASN1Sequence signatureSequence = ASN1Sequence.getInstance((Object)signature);
                    ASN1Sequence digestAlgoSeq = (ASN1Sequence)signatureSequence.getObjectAt(0);
                    DEROctetString digestOctectValue = (DEROctetString)signatureSequence.getObjectAt(1);
                    derivedDigest = digestOctectValue.getOctets();
                    ASN1ObjectIdentifier digestAlgoIdentifier = (ASN1ObjectIdentifier)digestAlgoSeq.getObjectAt(0);
                    rawDigest = AuthenticatedAttributesBuilder.makeDigest(data, digestAlgoIdentifier.getId());
                    break;
                }
                case 20: {
                    rawDigest = AuthenticatedAttributesBuilder.makeDigest(data, "SHA1");
                    derivedDigest = signature;
                    break;
                }
                case 16: {
                    rawDigest = AuthenticatedAttributesBuilder.makeDigest(data, "MD5");
                    derivedDigest = signature;
                    break;
                }
                default: {
                    throw new Exception("signature with length " + signature.length + " is not supported.");
                }
            }
            return Arrays.equals(rawDigest, derivedDigest);
        }
        catch (Exception e) {
            throw new EPSignatureException("Inner RSA verify failed. cause:" + e.getMessage(), e);
        }
    }

    public X509Certificate getSignerCert() {
        return this.signCert;
    }

    public byte[] getPrimaryContent() {
        return this.tobeSignedData;
    }
}

