/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7;

import cn.unitid.easypki.pkcs7.envelope.EPCMSContentEncryptorBuilder;
import cn.unitid.easypki.pkcs7.envelope.EPCMSEnvelopedDataGenerator;
import cn.unitid.easypki.pkcs7.envelope.EPKeyTransEnvelopedRecipient;
import cn.unitid.easypki.pkcs7.envelope.EPKeyTransRecipientInfoGenerator;
import cn.unitid.easypki.pkcs7.envelope.IssuerAndSerialNumber;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.operator.InputDecryptor;

public class EnvelopedDataGenerator {
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private X509Certificate recipient = null;
    private PrivateKey recipientPrivateKey;

    public void initRecipient(X509Certificate x509Certificate) {
        this.recipient = x509Certificate;
    }

    public void initRecipient(X509Certificate x509Certificate, PrivateKey privateKey) {
        this.recipient = x509Certificate;
        this.recipientPrivateKey = privateKey;
    }

    public byte[] envelopeSeal(byte[] data) throws IOException, CMSException, CertificateEncodingException {
        if (this.recipient == null) {
            throw new RuntimeException("\u63a5\u6536\u8005\u7684\u516c\u94a5\u8bc1\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.envelopeSeal(data, this.recipient);
    }

    public byte[] envelopeSeal(byte[] data, X509Certificate x509Certificate) throws IOException, CMSException, CertificateEncodingException {
        CMSEnvelopedData envelopedData;
        this.recipient = x509Certificate;
        if ("1.2.156.10197.1.501".equals(x509Certificate.getSigAlgOID())) {
            ASN1ObjectIdentifier gmt_data_type = new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1");
            CMSProcessableByteArray msg = new CMSProcessableByteArray(gmt_data_type, data);
            EPCMSEnvelopedDataGenerator edGen = new EPCMSEnvelopedDataGenerator();
            edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new EPKeyTransRecipientInfoGenerator(this.recipient));
            envelopedData = edGen.generate((CMSTypedData)msg, new EPCMSContentEncryptorBuilder(GMObjectIdentifiers.sms4_cbc, 16).build());
        } else {
            CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
            CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
            edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new EPKeyTransRecipientInfoGenerator(this.recipient));
            envelopedData = edGen.generate((CMSTypedData)msg, new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).build());
        }
        return envelopedData.getEncoded();
    }

    public byte[] envelopeOpen(byte[] envelopedData, InputDecryptor inputDecryptor) throws CMSException, IOException {
        return this.envelopeOpenImpl(envelopedData, inputDecryptor);
    }

    private byte[] envelopeOpenImpl(byte[] envelopedData, Object envelopedRecipient) throws CMSException, IOException {
        EPKeyTransEnvelopedRecipient keyTransEnvelopedRecipient = null;
        keyTransEnvelopedRecipient = envelopedRecipient instanceof PrivateKey ? new EPKeyTransEnvelopedRecipient((PrivateKey)envelopedRecipient) : new EPKeyTransEnvelopedRecipient((InputDecryptor)envelopedRecipient);
        byte[] openedData = null;
        CMSEnvelopedDataParser parser = new CMSEnvelopedDataParser(envelopedData);
        RecipientInformationStore recipients = parser.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            KeyTransRecipientId ktrid = (KeyTransRecipientId)recipient.getRID();
            org.bouncycastle.asn1.cms.IssuerAndSerialNumber isn = new org.bouncycastle.asn1.cms.IssuerAndSerialNumber(ktrid.getIssuer(), ktrid.getSerialNumber());
            this.issuerAndSerialNumber = new IssuerAndSerialNumber(isn.getName(), isn.getSerialNumber().getValue());
            openedData = recipient.getContent((Recipient)keyTransEnvelopedRecipient);
        }
        return openedData;
    }

    public byte[] envelopeOpen(byte[] envelopedData) throws CMSException, IOException {
        if (this.recipient == null) {
            throw new RuntimeException("\u63a5\u6536\u8005\u7684\u516c\u94a5\u8bc1\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.recipientPrivateKey == null) {
            throw new RuntimeException("\u63a5\u6536\u8005\u7684\u79c1\u94a5\u672a\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        byte[] openedData = null;
        CMSEnvelopedDataParser parser = new CMSEnvelopedDataParser(envelopedData);
        RecipientInformationStore recipients = parser.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        boolean isRecipientMatch = false;
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            KeyTransRecipientId ktrid = (KeyTransRecipientId)recipient.getRID();
            org.bouncycastle.asn1.cms.IssuerAndSerialNumber isn = new org.bouncycastle.asn1.cms.IssuerAndSerialNumber(ktrid.getIssuer(), ktrid.getSerialNumber());
            BigInteger recipientSerial = this.recipient.getSerialNumber();
            BigInteger targetSerial = isn.getSerialNumber().getValue();
            X500Principal targetIssuer = new X500Principal(isn.getName().getEncoded());
            X500Principal recipientIssuer = this.recipient.getIssuerX500Principal();
            if (!recipientSerial.equals(targetSerial) || !targetIssuer.equals(recipientIssuer)) continue;
            isRecipientMatch = true;
            this.issuerAndSerialNumber = new IssuerAndSerialNumber(isn.getName(), isn.getSerialNumber().getValue());
            openedData = recipient.getContent((Recipient)new EPKeyTransEnvelopedRecipient(this.recipientPrivateKey));
            break;
        }
        if (!isRecipientMatch) {
            throw new CMSException("\u63a5\u6536\u8005\u8bc1\u4e66\u4e0e\u6570\u5b57\u4fe1\u5c01\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u89e3\u5305\u6570\u5b57\u4fe1\u5c01");
        }
        return openedData;
    }

    public IssuerAndSerialNumber getIssuer() {
        return this.issuerAndSerialNumber;
    }
}

