/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7;

import cn.unitid.easypki.security.SM2Signature;
import cn.unitid.easypki.security.sm3.SM3Digest;
import cn.unitid.easypki.util.CertificateConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;

public class EPPKCS7Signature {
    private X509Certificate signCert;
    private byte[] plainData;
    private boolean noVerify = false;

    public EPPKCS7Signature() {
    }

    public EPPKCS7Signature(boolean noVerify) {
        this.noVerify = noVerify;
    }

    public boolean verify(String pkcs7Data) throws SignatureException {
        return this.verify(pkcs7Data, true);
    }

    public boolean verify(String pkcs7Data, byte[] plainData) throws SignatureException {
        if (null == plainData) {
            return this.verify(pkcs7Data, true);
        }
        this.plainData = plainData;
        return this.verify(pkcs7Data, false);
    }

    private boolean verify(String pkcs7Data, boolean attach) throws SignatureException {
        boolean verResult;
        ByteArrayOutputStream byteStream = null;
        try {
            byteStream = new ByteArrayOutputStream();
            if (!attach && this.plainData == null) {
                throw new SignatureException("\u975eAttach\u6a21\u5f0f\u4e0b,\u5fc5\u987b\u5148update\u5f85\u9a8c\u8bc1\u6570\u636e");
            }
            byte[] cmsSignedData = Base64.decode((String)pkcs7Data);
            CMSSignedData sd = new CMSSignedData(cmsSignedData);
            String contentTypeOID = sd.getSignedContentTypeOID();
            CMSSignedData signedData = null;
            signedData = contentTypeOID.equals(CMSObjectIdentifiers.data.getId()) ? (attach ? new CMSSignedData(cmsSignedData) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(PKCSObjectIdentifiers.data, this.plainData), cmsSignedData)) : (attach ? new CMSSignedData(cmsSignedData) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), this.plainData), cmsSignedData));
            CMSTypedData signedContent = signedData.getSignedContent();
            if (attach) {
                if (signedContent == null) {
                    throw new IOException("PKCS7\u7b7e\u540d\u4e2d\u6ca1\u6709\u5305\u542b\u7b7e\u540d\u6570\u636e");
                }
                signedContent.write((OutputStream)byteStream);
                this.plainData = byteStream.toByteArray();
            }
            if (this.noVerify) {
                boolean bl = true;
                return bl;
            }
            Store certStore = signedData.getCertificates();
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection collection = signers.getSigners();
            Iterator iterator = collection.iterator();
            int verified = 0;
            while (iterator.hasNext()) {
                byte[] calculatedMessageDigest;
                byte[] messageDigest;
                DEROctetString messageDigestOct;
                Attribute messageDigestAttr;
                byte[] signedAttributesContent;
                AttributeTable signedAttributes;
                byte[] signature;
                cn.unitid.easypki.cms.SignerInformation signer = cn.unitid.easypki.cms.SignerInformation.getInstance((SignerInformation)iterator.next(), (CMSProcessable)signedContent);
                Collection certCollection = certStore.getMatches((Selector)signer.getSID());
                Iterator it = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)it.next();
                if (contentTypeOID.equals(CMSObjectIdentifiers.data.getId())) {
                    String signatureAlgorithm;
                    this.signCert = CertificateConverter.fromBinary(cert.getEncoded());
                    signature = signer.getSignature();
                    signedAttributes = signer.getSignedAttributes();
                    signedAttributesContent = null;
                    if (signedAttributes != null) {
                        signedAttributesContent = signer.getEncodedSignedAttributes();
                        messageDigestAttr = signedAttributes.get(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
                        messageDigestOct = (DEROctetString)messageDigestAttr.getAttrValues().getObjectAt(0);
                        messageDigest = messageDigestOct.getOctets();
                        calculatedMessageDigest = null;
                        String digestHashAlgorithm = signer.getDigestAlgorithmID().getAlgorithm().getId();
                        if (!"1.3.14.3.2.26".equals(digestHashAlgorithm) && !"2.16.840.1.101.3.4.2.1".equals(digestHashAlgorithm)) {
                            throw new SignatureException("unsupported digest algorithm:" + signer.getDigestAlgorithmID().getAlgorithm().getId() + " in RSA P7");
                        }
                        calculatedMessageDigest = this.makeDigest((byte[])signedContent.getContent(), signer.getDigestAlgorithmID().getAlgorithm().getId());
                        if (!Arrays.equals(messageDigest, calculatedMessageDigest)) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        signedAttributesContent = this.plainData;
                    }
                    if (!this.verifyRSASignature(signatureAlgorithm = this.getRSASignatureAlgorithm(signer.getDigestAlgOID()), signature, signedAttributesContent, this.signCert)) continue;
                    ++verified;
                    continue;
                }
                this.signCert = CertificateConverter.fromBinary(cert.toASN1Structure().getEncoded());
                signature = signer.getSignature();
                signedAttributes = signer.getSignedAttributes();
                signedAttributesContent = null;
                if (signedAttributes != null) {
                    signedAttributesContent = signer.getEncodedSignedAttributes();
                    messageDigestAttr = signedAttributes.get(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
                    messageDigestOct = (DEROctetString)messageDigestAttr.getAttrValues().getObjectAt(0);
                    messageDigest = messageDigestOct.getOctets();
                    calculatedMessageDigest = null;
                    if (!"1.2.156.10197.1.401".equals(signer.getDigestAlgorithmID().getAlgorithm().getId())) {
                        throw new SignatureException("invalid digest algorithm:" + signer.getDigestAlgorithmID().getAlgorithm().getId() + " in SM2 Q7");
                    }
                    calculatedMessageDigest = this.makeSM3DigestWithoutPublicKey((byte[])signedContent.getContent());
                    if (!Arrays.equals(messageDigest, calculatedMessageDigest)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    signedAttributesContent = this.plainData;
                }
                SM2Signature sm2Signature = new SM2Signature();
                sm2Signature.initVerify(this.signCert);
                sm2Signature.update(signedAttributesContent);
                if (!sm2Signature.verify(signature)) continue;
                ++verified;
            }
            verResult = verified == collection.size();
        }
        catch (Exception e) {
            throw new SignatureException("\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5f02\u5e38. cause: " + e.getMessage(), e);
        }
        finally {
            try {
                if (byteStream != null) {
                    byteStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return verResult;
    }

    public X509Certificate getSignerCert() {
        return this.signCert;
    }

    public byte[] getPrimaryContent() {
        return this.plainData;
    }

    private String getRSASignatureAlgorithm(String digestAlgorithm) {
        String algorithm = null;
        algorithm = "2.16.840.1.101.3.4.2.1".equals(digestAlgorithm) ? "SHA256withRSA" : ("1.3.14.3.2.26".equals(digestAlgorithm) ? "SHA1withRSA" : digestAlgorithm);
        return algorithm;
    }

    private boolean verifyRSASignature(String signatureAlgorithm, byte[] rsaSignature, byte[] data, X509Certificate x509Certificate) throws SignatureException {
        boolean result = false;
        try {
            Signature signature = Signature.getInstance(signatureAlgorithm);
            signature.initVerify(x509Certificate);
            signature.update(data);
            result = signature.verify(rsaSignature);
        }
        catch (Exception e) {
            throw new SignatureException(e.getMessage(), e);
        }
        return result;
    }

    private byte[] digestToBinary(byte[] message, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = algorithm != null ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance("MD5");
        md.update(message);
        return md.digest();
    }

    private byte[] makeDigest(byte[] data, String digestAlgorithmIdentifier) {
        byte[] md = null;
        if (digestAlgorithmIdentifier.equals("1.3.14.3.2.26") || digestAlgorithmIdentifier.equals("2.16.840.1.101.3.4.2.1")) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithmIdentifier);
                messageDigest.update(data);
                md = messageDigest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        } else if (digestAlgorithmIdentifier.equals("1.2.156.10197.1.401")) {
            md = this.makeSM3DigestWithoutPublicKey(data);
        } else {
            throw new InvalidParameterException("invalid digest algorithm: " + digestAlgorithmIdentifier);
        }
        return md;
    }

    private byte[] makeSM3DigestWithoutPublicKey(byte[] toBeVerifiedData) {
        if (toBeVerifiedData == null) {
            throw new InvalidParameterException("data to be verified must be set first");
        }
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(toBeVerifiedData, 0, toBeVerifiedData.length);
        byte[] md = new byte[32];
        sm3Digest.doFinal(md, 0);
        return md;
    }
}

