/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7;

import cn.unitid.easypki.util.CertificateConverter;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;

public class CertificateChainParser {
    public static List<X509Certificate> parse(byte[] p7bBinary) throws CertificateParsingException {
        if (p7bBinary == null || p7bBinary.length < 1) {
            throw new NullPointerException("p7bBinary \u4e0d\u80fd\u4e3anull");
        }
        ArrayList<X509Certificate> chainList = new ArrayList<X509Certificate>();
        byte[] chainData = null;
        try {
            if (p7bBinary[0] == 45) {
                String b64Data = new String(p7bBinary);
                b64Data = b64Data.replace("-----BEGIN PKCS7-----", "").replace("-----END PKCS7-----", "").replace("\n", "");
                chainData = Base64.decode((String)b64Data);
            } else {
                chainData = p7bBinary[0] == 48 ? p7bBinary : Base64.decode((byte[])p7bBinary);
            }
            CMSSignedData signedData = new CMSSignedData(chainData);
            Store store = signedData.getCertificates();
            Collection xcs = store.getMatches(null);
            X509Certificate certificate = null;
            for (X509CertificateHolder xc : xcs) {
                certificate = CertificateConverter.fromBinary(xc.getEncoded());
                chainList.add(certificate);
            }
        }
        catch (CertificateException e) {
            throw new CertificateParsingException("\u8bc1\u4e66\u94fe\u89e3\u6790\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DecoderException e) {
            throw new CertificateParsingException("p7bBinary\u6570\u636e\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        catch (CMSException e) {
            throw new CertificateParsingException("\u6784\u9020CMSSignedData\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            throw new CertificateParsingException("\u672a\u77e5\u8bc1\u4e66\u94fe\u89e3\u6790\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return chainList;
    }
}

