/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7;

import cn.unitid.easypki.security.sm3.SM3Digest;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class AuthenticatedAttributesBuilder {
    public static ASN1EncodableVector buildAuthenticatedAttributes(byte[] data, AlgorithmIdentifier digAlgorithm) {
        ASN1EncodableVector contentTypeVector = new ASN1EncodableVector();
        contentTypeVector.add((ASN1Encodable)PKCSObjectIdentifiers.pkcs_9_at_contentType);
        ASN1EncodableVector pkcs7Vector = new ASN1EncodableVector();
        pkcs7Vector.add((ASN1Encodable)PKCSObjectIdentifiers.data);
        contentTypeVector.add((ASN1Encodable)new DERSet(pkcs7Vector));
        DERSequence contentTypeSequence = new DERSequence(contentTypeVector);
        ASN1EncodableVector sigTimeVector = new ASN1EncodableVector();
        sigTimeVector.add((ASN1Encodable)PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        ASN1EncodableVector timeVector = new ASN1EncodableVector();
        timeVector.add((ASN1Encodable)new ASN1UTCTime(new Date()));
        sigTimeVector.add((ASN1Encodable)new DERSet(timeVector));
        DERSequence sigTimeSequence = new DERSequence(sigTimeVector);
        ASN1EncodableVector messageDigestVector = new ASN1EncodableVector();
        messageDigestVector.add((ASN1Encodable)PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        ASN1EncodableVector digestVector = new ASN1EncodableVector();
        byte[] messageDigest = AuthenticatedAttributesBuilder.makeDigest(data, digAlgorithm.getAlgorithm().getId());
        digestVector.add((ASN1Encodable)new DEROctetString(messageDigest));
        messageDigestVector.add((ASN1Encodable)new DERSet(digestVector));
        DERSequence messageDigestSequence = new DERSequence(messageDigestVector);
        ASN1EncodableVector attrVector = new ASN1EncodableVector();
        attrVector.add((ASN1Encodable)contentTypeSequence);
        attrVector.add((ASN1Encodable)sigTimeSequence);
        attrVector.add((ASN1Encodable)messageDigestSequence);
        return attrVector;
    }

    public static byte[] makeDigest(byte[] data, String digestAlgorithmIdentifier) {
        byte[] md = null;
        if (digestAlgorithmIdentifier.equals("1.3.14.3.2.26") || digestAlgorithmIdentifier.equals("2.16.840.1.101.3.4.2.1")) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithmIdentifier);
                messageDigest.update(data);
                md = messageDigest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        } else if (digestAlgorithmIdentifier.equals("1.2.156.10197.1.401")) {
            md = AuthenticatedAttributesBuilder.makeSM3DigestWithoutPublicKey(data);
        } else {
            throw new InvalidParameterException("invalid digest algorithm: " + digestAlgorithmIdentifier);
        }
        return md;
    }

    public static byte[] makeSM3DigestWithoutPublicKey(byte[] toBeVerifiedData) {
        if (toBeVerifiedData == null) {
            throw new InvalidParameterException("data to be verified must be set first");
        }
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(toBeVerifiedData, 0, toBeVerifiedData.length);
        byte[] md = new byte[32];
        sm3Digest.doFinal(md, 0);
        return md;
    }
}

