/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.crypto;

import cn.unitid.easypki.asn1.sm2.application.SM2Cipher;
import cn.unitid.easypki.crypto.ByteConverter;
import cn.unitid.easypki.crypto.CipherException;
import cn.unitid.easypki.crypto.SM3Digest;
import cn.unitid.easypki.provider.asymmetric.sm2.SM2BCPublicKey;
import cn.unitid.easypki.security.SM2BCKeyPairGenerator;
import cn.unitid.easypki.security.ec.ECDomainParametersHelper;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.Key;
import java.util.Arrays;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.ECPoint;

public class SM2AsymmetricCipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private int ct = 1;
    private ECPoint p2;
    private SM3Digest sm3KeyBase;
    private SM3Digest sm3c3;
    private byte[] key = new byte[32];
    private byte keyOff = 0;
    private int mode = -1;
    private Key sm2Key = null;
    private byte[] data = null;

    public void init(int mode, Key key) {
        if (key == null) {
            throw new NullPointerException("\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (mode != 1 && mode != 2) {
            throw new InvalidParameterException("\u65e0\u6548\u7684\u64cd\u4f5c\u6a21\u5f0f\uff1a" + mode);
        }
        this.mode = mode;
        this.sm2Key = key;
    }

    public void update(byte[] data) {
        if (data == null) {
            throw new NullPointerException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (this.data == null) {
            this.data = (byte[])data.clone();
        } else {
            byte[] newData = new byte[this.data.length + data.length];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            System.arraycopy(data, 0, newData, this.data.length, data.length);
            this.data = newData;
        }
    }

    public byte[] doFinal() throws CipherException {
        byte[] finalData;
        block7: {
            finalData = null;
            if (this.mode == -1 || this.key == null) {
                throw new CipherException("\u8bf7\u5148\u521d\u59cb\u5316\u52a0\u89e3\u5bc6\u6a21\u5f0f\u53ca\u5bc6\u94a5");
            }
            try {
                if (this.mode == 1) {
                    Object publicKey;
                    ECPoint c1 = null;
                    if (this.sm2Key instanceof BCECPublicKey) {
                        publicKey = (BCECPublicKey)this.sm2Key;
                        c1 = this.initEncipher(publicKey.getQ());
                    } else {
                        publicKey = (SM2BCPublicKey)((Object)this.sm2Key);
                        c1 = this.initEncipher(((SM2BCPublicKey)publicKey).getQ());
                    }
                    this.encrypt(this.data);
                    byte[] c2 = this.data;
                    byte[] c3 = new byte[32];
                    this.doFinal(c3);
                    SM2Cipher sm2c = new SM2Cipher(c1.getAffineXCoord().toBigInteger(), c1.getAffineYCoord().toBigInteger(), c3, c2);
                    finalData = sm2c.getEncoded();
                    break block7;
                }
                BCECPrivateKey privateKey = (BCECPrivateKey)this.sm2Key;
                SM2Cipher sm2c = SM2Cipher.getInstance(this.data);
                ECPoint c1 = ECDomainParametersHelper.getECCurve().createPoint(sm2c.getXCoordinate().getPositiveValue(), sm2c.getYCoordinate().getPositiveValue());
                this.initDecipher(privateKey.getD(), c1);
                byte[] cipherData = sm2c.getCipherText().getOctets();
                this.decrypt(cipherData);
                byte[] c3 = new byte[32];
                this.doFinal(c3);
                if (Arrays.equals(sm2c.getHash().getOctets(), c3)) {
                    finalData = cipherData;
                    break block7;
                }
                throw new CipherException("\u89e3\u5bc6\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0:hash\u503c\u4e0d\u4e00\u81f4");
            }
            catch (IOException e) {
                throw new CipherException("\u52a0\u5bc6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage(), e);
            }
        }
        return finalData;
    }

    private void reset() {
        this.sm3KeyBase = new SM3Digest();
        this.sm3c3 = new SM3Digest();
        byte[] p = ByteConverter.convertTo32Bytes(this.p2.normalize().getXCoord().toBigInteger());
        this.sm3KeyBase.update(p, 0, p.length);
        this.sm3c3.update(p, 0, p.length);
        p = ByteConverter.convertTo32Bytes(this.p2.normalize().getYCoord().toBigInteger());
        this.sm3KeyBase.update(p, 0, p.length);
        this.ct = 1;
        this.nextKey();
    }

    private void nextKey() {
        SM3Digest sm3keycur = new SM3Digest(this.sm3KeyBase);
        sm3keycur.update((byte)(this.ct >> 24 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 16 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 8 & 0xFF));
        sm3keycur.update((byte)(this.ct & 0xFF));
        sm3keycur.doFinal(this.key, 0);
        this.keyOff = 0;
        ++this.ct;
    }

    private ECPoint initEncipher(ECPoint userKey) {
        BigInteger k = null;
        ECPoint c1 = null;
        AsymmetricCipherKeyPair keyPair = SM2BCKeyPairGenerator.generateAsymmetricCipherKeyPair();
        ECPrivateKeyParameters ecPrivateKey = (ECPrivateKeyParameters)keyPair.getPrivate();
        ECPublicKeyParameters ecPublicKey = (ECPublicKeyParameters)keyPair.getPublic();
        k = ecPrivateKey.getD();
        c1 = ecPublicKey.getQ();
        this.p2 = userKey.multiply(k);
        this.reset();
        return c1;
    }

    private void encrypt(byte[] data) {
        this.sm3c3.update(data, 0, data.length);
        int i = 0;
        while (i < data.length) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
    }

    private void initDecipher(BigInteger userD, ECPoint c1) {
        this.p2 = c1.multiply(userD);
        this.reset();
    }

    private void decrypt(byte[] data) {
        int i = 0;
        while (i < data.length) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
        this.sm3c3.update(data, 0, data.length);
    }

    private void doFinal(byte[] c3) {
        byte[] p = ByteConverter.convertTo32Bytes(this.p2.normalize().getYCoord().toBigInteger());
        this.sm3c3.update(p, 0, p.length);
        this.sm3c3.doFinal(c3, 0);
        this.reset();
    }
}

