/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.cms;

import cn.unitid.easypki.provider.identifier.EPAlgorithmIdentifier;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSSignatureEncryptionAlgorithmFinder;

public class TSASignatureEncryptionAlgorithmFinder
implements CMSSignatureEncryptionAlgorithmFinder {
    public AlgorithmIdentifier findEncryptionAlgorithm(AlgorithmIdentifier signatureAlgorithm) {
        AlgorithmIdentifier encryptionAlgorithm = null;
        String algorithmId = signatureAlgorithm.getAlgorithm().getId();
        if ("1.2.156.10197.1.501".equals(algorithmId)) {
            encryptionAlgorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.301.1"));
        } else if ("1.2.840.113549.1.1.11".equals(algorithmId)) {
            encryptionAlgorithm = EPAlgorithmIdentifier.SHA256_WITH_RSA_ENCRYPTION_ALGORITHM;
        } else {
            throw new RuntimeException("unsupported algorithm:" + algorithmId);
        }
        return encryptionAlgorithm;
    }
}

