/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.asn1.sm2.syntax;

import cn.unitid.easypki.asn1.ec.ECParameters;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLTaggedObject;

public class ECPrivateKey
extends ASN1Object {
    private ASN1Integer version = new ASN1Integer(1L);
    private DEROctetString privateKey;
    private ECParameters parameters;
    private DERBitString publicKey;

    private ECPrivateKey(ASN1Sequence sequence) {
        this.version = (ASN1Integer)sequence.getObjectAt(0);
        this.privateKey = (DEROctetString)sequence.getObjectAt(1);
        DLTaggedObject taggedObject = (DLTaggedObject)sequence.getObjectAt(2);
        ASN1ObjectIdentifier identifier = (ASN1ObjectIdentifier)taggedObject.getObject();
        this.parameters = new ECParameters(identifier);
        DLTaggedObject pubObject = (DLTaggedObject)sequence.getObjectAt(3);
        this.publicKey = (DERBitString)pubObject.getObject();
    }

    public static ECPrivateKey getInstance(Object object) {
        ECPrivateKey instance = null;
        if (object instanceof ECPrivateKey) {
            instance = (ECPrivateKey)((Object)object);
        } else if (object instanceof ASN1Sequence) {
            instance = new ECPrivateKey(ASN1Sequence.getInstance((Object)object));
        } else if (object instanceof byte[]) {
            instance = new ECPrivateKey(ASN1Sequence.getInstance((Object)ASN1Sequence.getInstance((Object)object)));
        }
        return instance;
    }

    public ECPrivateKey(byte[] sm2PrivateKey, ECParameters parameters, byte[] publicKey) {
        this.privateKey = new DEROctetString(sm2PrivateKey);
        this.parameters = parameters;
        this.publicKey = new DERBitString(publicKey);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.privateKey);
        this.addOptional(v, 0, (ASN1Encodable)this.parameters);
        this.addOptional(v, 1, (ASN1Encodable)this.publicKey);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add((ASN1Encodable)new DERTaggedObject(true, tagNo, obj));
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public DEROctetString getPrivateKey() {
        return this.privateKey;
    }

    public ECParameters getParameters() {
        return this.parameters;
    }

    public DERBitString getPublicKey() {
        return this.publicKey;
    }
}

