/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.asn1.sm2.application;

import cn.unitid.easypki.asn1.sm2.application.SM2Signature;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.util.encoders.Base64;

public class UnsafeSM2Signature {
    public static String transfer(String b64Signature) {
        byte[] binarySignature = Base64.decode((String)b64Signature);
        return Base64.toBase64String((byte[])UnsafeSM2Signature.transfer(binarySignature));
    }

    public static byte[] transfer(byte[] binarySignature) {
        SM2Signature sm2Signature = SM2Signature.getInstance(binarySignature);
        return UnsafeSM2Signature.getEncoded(sm2Signature.getR(), sm2Signature.getS());
    }

    public static void main(String[] args) {
        String s1 = "MEQCIQDmG1aWeLu+6ya7+e/8agr2QAaZzeQ6vLfydC6aRiyTzQIfCHxLXKCq632e92xnunO1uKcnjFvYRQMNC26a+atcRA==";
        String s2 = "MEUCIQDmG1aWeLu+6ya7+e/8agr2QAaZzeQ6vLfydC6aRiyTzQIgAAh8S1ygqut9nvdsZ7pztbinJ4xb2EUDDQtumvmrXEQ=";
        byte[] b1 = Base64.decode((String)s1);
        byte[] b2 = Base64.decode((String)s2);
        SM2Signature sm2Signature = SM2Signature.getInstance(b1);
        byte[] signature = UnsafeSM2Signature.getEncoded(sm2Signature.getR(), sm2Signature.getS());
        System.out.println(1);
    }

    public static byte[] getEncoded(ASN1Integer r, ASN1Integer s) {
        byte[] asnR = UnsafeSM2Signature.format(r.getPositiveValue().toByteArray());
        byte[] asnS = UnsafeSM2Signature.format(s.getPositiveValue().toByteArray());
        int rLength = asnR.length;
        int sLength = asnS.length;
        byte[] asnSignature = new byte[rLength + sLength + 2];
        asnSignature[0] = 48;
        asnSignature[1] = (byte)(rLength + sLength);
        System.arraycopy(asnR, 0, asnSignature, 2, rLength);
        System.arraycopy(asnS, 0, asnSignature, rLength + 2, sLength);
        return asnSignature;
    }

    private static byte[] format(byte[] value) {
        int length = value.length;
        int copyPosition = 2;
        byte[] asnBinary = null;
        if (length <= 31) {
            copyPosition = 34 - value.length;
            asnBinary = new byte[34];
            asnBinary[0] = 2;
            asnBinary[1] = 32;
        } else {
            asnBinary = new byte[length + 2];
            asnBinary[0] = 2;
            asnBinary[1] = (byte)length;
        }
        System.arraycopy(value, 0, asnBinary, copyPosition, length);
        return asnBinary;
    }
}

