/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.asn1.ec;

import cn.unitid.easypki.asn1.ec.ECParameters;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class ECPrivateKey
extends ASN1Object {
    private ASN1Integer version;
    private ASN1Integer privateKey;
    private DEROctetString privateKeyString = null;
    private ECParameters parameters;
    private DERBitString publicKey;

    public ECPrivateKey(BigInteger privateKey, ASN1ObjectIdentifier namedCurve) {
        this.version = new ASN1Integer(1L);
        this.privateKey = new ASN1Integer(privateKey);
        this.parameters = new ECParameters(namedCurve);
    }

    public ECPrivateKey(BigInteger version, byte[] privateKey, ASN1ObjectIdentifier namedCurve) {
        this.version = new ASN1Integer(version);
        this.privateKey = new ASN1Integer(privateKey);
        this.parameters = new ECParameters(namedCurve);
    }

    public ECPrivateKey(byte[] privateKey, ASN1ObjectIdentifier namedCurve, byte[] pubicKey) {
        this.version = new ASN1Integer(1L);
        this.privateKey = new ASN1Integer(privateKey);
        this.parameters = new ECParameters(namedCurve);
        this.publicKey = new DERBitString(pubicKey);
    }

    public ECPrivateKey(DEROctetString privateKey, ASN1ObjectIdentifier namedCurve, byte[] pubicKey) {
        this.version = new ASN1Integer(1L);
        this.privateKeyString = privateKey;
        this.parameters = new ECParameters(namedCurve);
        this.publicKey = new DERBitString(pubicKey);
    }

    private ECPrivateKey(ASN1Sequence sequence) {
        this.version = (ASN1Integer)sequence.getObjectAt(0);
        this.privateKey = (ASN1Integer)sequence.getObjectAt(1);
        ASN1Encodable object = sequence.getObjectAt(2);
        if (object instanceof ECParameters) {
            this.parameters = (ECParameters)object;
        } else {
            this.publicKey = DERBitString.getInstance((Object)object);
        }
    }

    public static ECPrivateKey getInstance(Object object) {
        ECPrivateKey instance = null;
        if (object instanceof ECPrivateKey) {
            instance = (ECPrivateKey)((Object)object);
        } else if (object instanceof byte[]) {
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)object);
            instance = new ECPrivateKey(sequence);
        } else if (object instanceof ASN1Sequence) {
            instance = new ECPrivateKey((ASN1Sequence)object);
        }
        return instance;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        if (this.privateKey != null) {
            v.add((ASN1Encodable)this.privateKey);
        }
        if (this.privateKeyString != null) {
            v.add((ASN1Encodable)this.privateKeyString);
        }
        this.addOptional(v, 0, (ASN1Encodable)this.parameters);
        this.addOptional(v, 1, (ASN1Encodable)this.publicKey);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add((ASN1Encodable)new DERTaggedObject(true, tagNo, obj));
        }
    }
}

